/*
 * Decompiled with CFR 0.152.
 */
package sign;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.sign.signer.Secp256k1Blake160MultisigAllSigner;
import org.nervos.ckb.utils.Numeric;
import sign.SignerChecker;

public class Secp256k1Blake160MultisigAllSignerTest {
    @Test
    public void testMultiScriptEncode() {
        ArrayList<byte[]> keyHashes = new ArrayList<byte[]>();
        keyHashes.add(Numeric.hexStringToByteArray((String)"0x9b41c025515b00c24e2e2042df7b221af5c1891f"));
        keyHashes.add(Numeric.hexStringToByteArray((String)"0xe732dcd15b7618eb1d7a11e6a68e4579b5be0114"));
        Secp256k1Blake160MultisigAllSigner.MultisigScript multisigScript = new Secp256k1Blake160MultisigAllSigner.MultisigScript(0, 2, keyHashes);
        Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)"0x000002029b41c025515b00c24e2e2042df7b221af5c1891fe732dcd15b7618eb1d7a11e6a68e4579b5be0114"), (byte[])multisigScript.encode());
        Assertions.assertArrayEquals((byte[])Numeric.hexStringToByteArray((String)"0x35ed7b939b4ac9cb447b82340fd8f26d344f7a62"), (byte[])multisigScript.computeHash());
    }

    @Test
    public void testMultiScriptDecode() {
        ArrayList<byte[]> keyHashes = new ArrayList<byte[]>();
        keyHashes.add(Numeric.hexStringToByteArray((String)"0x9b41c025515b00c24e2e2042df7b221af5c1891f"));
        keyHashes.add(Numeric.hexStringToByteArray((String)"0xe732dcd15b7618eb1d7a11e6a68e4579b5be0114"));
        Secp256k1Blake160MultisigAllSigner.MultisigScript multisigScript = new Secp256k1Blake160MultisigAllSigner.MultisigScript(0, 2, keyHashes);
        Assertions.assertEquals((Object)Secp256k1Blake160MultisigAllSigner.MultisigScript.decode((byte[])Numeric.hexStringToByteArray((String)"0x000002029b41c025515b00c24e2e2042df7b221af5c1891fe732dcd15b7618eb1d7a11e6a68e4579b5be0114")), (Object)multisigScript);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Secp256k1Blake160MultisigAllSigner.MultisigScript.decode((byte[])Numeric.hexStringToByteArray((String)"0x000002039b41c025515b00c24e2e2042df7b221af5c1891fe732dcd15b7618eb1d7a11e6a68e4579b5be0114")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Secp256k1Blake160MultisigAllSigner.MultisigScript.decode((byte[])Numeric.hexStringToByteArray((String)"0x000002029b41c025515b00c24e2e2042df7b221af5c1891f")));
    }

    @Test
    public void testFirstSign() {
        SignerChecker.signAndCheck("secp256k1_blake160_multisig_all_first");
    }

    @Test
    public void testSecondSign() {
        SignerChecker.signAndCheck("secp256k1_blake160_multisig_all_second");
    }
}

