/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.omnilock.molecule;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.nervos.ckb.type.base.Array;
import org.nervos.ckb.type.base.MoleculeException;

public final class Auth
extends Array {
    public static Class ITEM_TYPE = Byte.TYPE;
    public static int ITEM_SIZE = 1;
    public static int ITEM_COUNT = 21;
    public static int SIZE = ITEM_SIZE * ITEM_COUNT;
    private byte[] items;

    private Auth() {
    }

    @Nonnull
    public byte get(int i) {
        return this.items[i];
    }

    @Nullable
    public byte[] getItems() {
        return this.items;
    }

    public int getItemCount() {
        return ITEM_COUNT;
    }

    public int getItemSize() {
        return ITEM_SIZE;
    }

    public Class getItemType() {
        return ITEM_TYPE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@Nonnull byte[] buf) {
        return new Builder(buf);
    }

    static /* synthetic */ byte[] access$302(Auth x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$402(Auth x0, byte[] x1) {
        x0.items = x1;
        return x1;
    }

    public static final class Builder {
        private byte[] items;

        private Builder() {
            this.items = new byte[ITEM_COUNT];
        }

        private Builder(@Nonnull byte[] buf) {
            Objects.requireNonNull(buf);
            if (buf.length != SIZE) {
                throw MoleculeException.invalidByteSize((int)SIZE, (int)buf.length, Auth.class);
            }
            this.items = buf;
        }

        public Builder set(int i, @Nonnull byte item) {
            Objects.requireNonNull(item);
            this.items[i] = item;
            return this;
        }

        public Builder set(@Nonnull byte[] items) {
            Objects.requireNonNull(items);
            if (items.length != ITEM_COUNT) {
                throw MoleculeException.invalidItemCount((int)ITEM_COUNT, (int)items.length, Auth.class);
            }
            this.items = items;
            return this;
        }

        public Auth build() {
            Auth a = new Auth();
            Auth.access$302(a, this.items);
            Auth.access$402(a, this.items);
            return a;
        }
    }
}

