/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.signer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.nervos.ckb.crypto.Blake2b;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.crypto.secp256k1.Sign;
import org.nervos.ckb.sign.Context;
import org.nervos.ckb.sign.ScriptGroup;
import org.nervos.ckb.sign.ScriptSigner;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.Transaction;
import org.nervos.ckb.type.WitnessArgs;
import org.nervos.ckb.utils.MoleculeConverter;

public class Secp256k1Blake160SighashAllSigner
implements ScriptSigner {
    public static boolean signTransactionInPlace(Transaction transaction, ScriptGroup scriptGroup, ECKeyPair keyPair) {
        byte[] signature = Secp256k1Blake160SighashAllSigner.signTransaction(transaction, scriptGroup, keyPair);
        List<byte[]> witnesses = transaction.witnesses;
        int index = scriptGroup.getInputIndices().get(0);
        WitnessArgs witnessArgs = WitnessArgs.unpack(witnesses.get(index));
        witnessArgs.setLock(signature);
        witnesses.set(index, witnessArgs.pack().toByteArray());
        return true;
    }

    public static byte[] signTransaction(Transaction transaction, ScriptGroup scriptGroup, byte[] witnessPlaceholder, ECKeyPair keyPair) {
        int i;
        byte[] txHash = transaction.computeHash();
        Blake2b blake2b = new Blake2b();
        blake2b.update(txHash);
        blake2b.update(MoleculeConverter.packUint64(witnessPlaceholder.length).toByteArray());
        blake2b.update(witnessPlaceholder);
        ArrayList<Integer> includedWitnessIndex = new ArrayList<Integer>();
        for (i = 1; i < scriptGroup.getInputIndices().size(); ++i) {
            includedWitnessIndex.add(scriptGroup.getInputIndices().get(i));
        }
        for (i = transaction.inputs.size(); i < transaction.witnesses.size(); ++i) {
            includedWitnessIndex.add(i);
        }
        Iterator i2 = includedWitnessIndex.iterator();
        while (i2.hasNext()) {
            int i3 = (Integer)i2.next();
            byte[] witness = transaction.witnesses.get(i3);
            blake2b.update(MoleculeConverter.packUint64(witness.length).toByteArray());
            blake2b.update(witness);
        }
        byte[] message = blake2b.doFinal();
        byte[] signature = Sign.signMessage((byte[])message, (ECKeyPair)keyPair).getSignature();
        return signature;
    }

    public static byte[] signTransaction(Transaction transaction, ScriptGroup scriptGroup, ECKeyPair keyPair) {
        byte[] witnessPlaceholder = transaction.witnesses.get(scriptGroup.getInputIndices().get(0));
        return Secp256k1Blake160SighashAllSigner.signTransaction(transaction, scriptGroup, witnessPlaceholder, keyPair);
    }

    @Override
    public boolean signTransaction(Transaction transaction, ScriptGroup scriptGroup, Context context) {
        Script script = scriptGroup.getScript();
        ECKeyPair keyPair = context.getKeyPair();
        if (Secp256k1Blake160SighashAllSigner.isMatched(keyPair, script.args)) {
            return Secp256k1Blake160SighashAllSigner.signTransactionInPlace(transaction, scriptGroup, keyPair);
        }
        return false;
    }

    public static boolean isMatched(ECKeyPair keyPair, byte[] scriptArgs) {
        if (scriptArgs == null || keyPair == null) {
            return false;
        }
        byte[] hash = Blake2b.digest((byte[])keyPair.getEncodedPublicKey(true));
        hash = Arrays.copyOfRange(hash, 0, 20);
        return Arrays.equals(scriptArgs, hash);
    }
}

