/*
 * Decompiled with CFR 0.152.
 */
package type;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.type.CellOutput;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.Numeric;
import utils.TestUtils;

public class CellOutputTest {
    @Test
    public void testOccupiedCapacity() {
        CellOutput cellOutput = new CellOutput(100000000000L, TestUtils.createScript("0x68d5438ac952d2f584abf879527946a537e82c7f3c1cbf6d8ebf9767437d8e88", "0x59a27ef3ba84f061517d13f42cf44ed020610061", Script.HashType.TYPE));
        Assertions.assertEquals((long)6100000000L, (long)cellOutput.occupiedCapacity(new byte[0]));
    }

    @Test
    public void testOccupiedCapacityWithData() {
        CellOutput cellOutput = new CellOutput(100000000000L, TestUtils.createScript("0x68d5438ac952d2f584abf879527946a537e82c7f3c1cbf6d8ebf9767437d8e88", "0x59a27ef3ba84f061517d13f42cf44ed020610061", Script.HashType.TYPE));
        Assertions.assertEquals((long)9300000000L, (long)cellOutput.occupiedCapacity(Numeric.hexStringToByteArray((String)"0x68d5438ac952d2f584abf879527946a537e82c7f3c1cbf6d8ebf9767437d8e88")));
    }
}

