/*
 * Decompiled with CFR 0.152.
 */
package utils;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.Network;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.Address;
import org.nervos.ckb.utils.address.AddressFormatException;

public class AddressTest {
    @Test
    public void testDecodeDecode() {
        Script script = this.generateScript(Script.SECP256K1_BLAKE160_SIGNHASH_ALL_CODE_HASH, "b39bbc0b3673c7d36450bc14cfcdad2d559c6c64", Script.HashType.TYPE);
        this.testShort(script, Network.MAINNET, "ckb1qyqt8xaupvm8837nv3gtc9x0ekkj64vud3jqfwyw5v");
        this.testShort(script, Network.TESTNET, "ckt1qyqt8xaupvm8837nv3gtc9x0ekkj64vud3jq5t63cs");
        script = this.generateScript(Script.SECP256K1_BLAKE160_MULTISIG_ALL_CODE_HASH, "4fb2be2e5d0c1a3b8694f832350a33c1685d477a", Script.HashType.TYPE);
        this.testShort(script, Network.MAINNET, "ckb1qyq5lv479ewscx3ms620sv34pgeuz6zagaaqklhtgg");
        this.testShort(script, Network.TESTNET, "ckt1qyq5lv479ewscx3ms620sv34pgeuz6zagaaqt6f5y5");
        script = this.generateScript(Script.ANY_CAN_PAY_CODE_HASH_MAINNET, "bd07d9f32bce34d27152a6a0391d324f79aab854", Script.HashType.TYPE);
        this.testShort(script, Network.MAINNET, "ckb1qypt6p7e7v4uudxjw9f2dgper5ey77d2hp2qxz4u4u");
        script = this.generateScript(Script.ANY_CAN_PAY_CODE_HASH_TESTNET, "bd07d9f32bce34d27152a6a0391d324f79aab854", Script.HashType.TYPE);
        this.testShort(script, Network.TESTNET, "ckt1qypt6p7e7v4uudxjw9f2dgper5ey77d2hp2qm8treq");
        script = this.generateScript("9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "b39bbc0b3673c7d36450bc14cfcdad2d559c6c64", Script.HashType.DATA);
        this.testFullBech32(script, Network.MAINNET, "ckb1q2da0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xw3vumhs9nvu786dj9p0q5elx66t24n3kxgdwd2q8");
        this.testFullBech32(script, Network.TESTNET, "ckt1q2da0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xw3vumhs9nvu786dj9p0q5elx66t24n3kxgqd588c");
        script = this.generateScript("9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "b39bbc0b3673c7d36450bc14cfcdad2d559c6c64", Script.HashType.TYPE);
        this.testFullBech32(script, Network.MAINNET, "ckb1qjda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xw3vumhs9nvu786dj9p0q5elx66t24n3kxgj53qks");
        this.testFullBech32(script, Network.TESTNET, "ckt1qjda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xw3vumhs9nvu786dj9p0q5elx66t24n3kxglhgd30");
        script = this.generateScript("9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "b39bbc0b3673c7d36450bc14cfcdad2d559c6c64", Script.HashType.DATA);
        this.testFullBech32m(script, Network.MAINNET, "ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq9nnw7qkdnnclfkg59uzn8umtfd2kwxceqvguktl");
        this.testFullBech32m(script, Network.TESTNET, "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq9nnw7qkdnnclfkg59uzn8umtfd2kwxceqz6hep8");
        script = this.generateScript("9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "b39bbc0b3673c7d36450bc14cfcdad2d559c6c64", Script.HashType.TYPE);
        this.testFullBech32m(script, Network.MAINNET, "ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqdnnw7qkdnnclfkg59uzn8umtfd2kwxceqxwquc4");
        this.testFullBech32m(script, Network.TESTNET, "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqdnnw7qkdnnclfkg59uzn8umtfd2kwxceqgutnjd");
        script = this.generateScript("9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8", "b39bbc0b3673c7d36450bc14cfcdad2d559c6c64", Script.HashType.DATA1);
        this.testFullBech32m(script, Network.MAINNET, "ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq4nnw7qkdnnclfkg59uzn8umtfd2kwxceqcydzyt");
        this.testFullBech32m(script, Network.TESTNET, "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq4nnw7qkdnnclfkg59uzn8umtfd2kwxceqkkxdwn");
    }

    private void testShort(Script script, Network network, String encoded) {
        Address address = new Address(script, network);
        Assertions.assertEquals((Object)encoded, (Object)address.encodeShort());
        Assertions.assertEquals((Object)address, (Object)Address.decode((String)encoded));
    }

    private void testFullBech32(Script script, Network network, String encoded) {
        Address address = new Address(script, network);
        Assertions.assertEquals((Object)encoded, (Object)address.encodeFullBech32());
        Assertions.assertEquals((Object)address, (Object)Address.decode((String)encoded));
    }

    private void testFullBech32m(Script script, Network network, String encoded) {
        Address address = new Address(script, network);
        Assertions.assertEquals((Object)encoded, (Object)address.encodeFullBech32m());
        Assertions.assertEquals((Object)address, (Object)Address.decode((String)encoded));
    }

    @Test
    public void testInvalidDecode() {
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qyqylv479ewscx3ms620sv34pgeuz6zagaaqh0knz7"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qyqylv479ewscx3ms620sv34pgeuz6zagaarxdzvx03"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qyg5lv479ewscx3ms620sv34pgeuz6zagaaqajch0c"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1q2da0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsnajhch96rq68wrqn2tmhm"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq20k2lzuhgvrgacv4tmr88"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqz0k2lzuhgvrgacvhcym08"));
        Assertions.assertThrows(AddressFormatException.class, () -> Address.decode((String)"ckb1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqj0k2lzuhgvrgacvnhnzl8"));
    }

    private Script generateScript(String codeHash, String args, Script.HashType hashType) {
        return new Script(Numeric.hexStringToByteArray((String)codeHash), Numeric.hexStringToByteArray((String)args), hashType);
    }

    private Script generateScript(byte[] codeHash, String args, Script.HashType hashType) {
        return new Script(codeHash, Numeric.hexStringToByteArray((String)args), hashType);
    }
}

