/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.omnilock;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.nervos.ckb.sign.omnilock.AuthFlag;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.Address;

public class OmnilockArgs {
    private Authentication authentication;
    private OmniConfig omniConfig;

    public OmnilockArgs(String address) {
        this(Address.decode((String)address).getScript().args);
    }

    public OmnilockArgs(byte[] args) {
        this.authentication = Authentication.decode(args);
        this.omniConfig = OmniConfig.decode(Arrays.copyOfRange(args, 21, args.length));
    }

    public OmnilockArgs(Authentication authentication, OmniConfig omniConfig) {
        this.authentication = authentication;
        this.omniConfig = omniConfig;
    }

    public byte[] encode() {
        byte[] args1 = this.authentication.encode();
        byte[] args2 = this.omniConfig.encode();
        return Numeric.concatBytes((byte[])args1, (byte[])args2);
    }

    public Authentication getAuthenticationArgs() {
        return this.authentication;
    }

    public void setAuthenticationArgs(Authentication authentication) {
        this.authentication = authentication;
    }

    public OmniConfig getOmniArgs() {
        return this.omniConfig;
    }

    public void setOmniArgs(OmniConfig omniConfig) {
        this.omniConfig = omniConfig;
    }

    public static class OmniConfig {
        private int flag;
        private byte[] adminListCellTypeId;
        private Integer minimumCKBExponentInAcp;
        private Integer minimumSUDTExponentInAcp;
        private Long sinceForTimeLock;
        private byte[] typeScriptHashForSupply;

        public static OmniConfig decode(byte[] raw) {
            OmniConfig args = new OmniConfig();
            args.flag = raw[0];
            if (args.isAdminModeEnabled()) {
                args.adminListCellTypeId = Arrays.copyOfRange(raw, 1, 33);
            }
            if (args.isAnyoneCanPayModeEnabled()) {
                args.minimumCKBExponentInAcp = Byte.toUnsignedInt(raw[33]);
                args.minimumSUDTExponentInAcp = Byte.toUnsignedInt(raw[34]);
            }
            if (args.isTimeLockModeEnabled()) {
                ByteBuffer buffer = ByteBuffer.wrap(raw, 35, 8);
                args.sinceForTimeLock = buffer.getLong();
            }
            if (args.isSupplyModeEnabled()) {
                args.typeScriptHashForSupply = Arrays.copyOfRange(raw, 43, 75);
            }
            return args;
        }

        private void writeBytes(ByteArrayOutputStream out, byte[] bytes) {
            out.write(bytes, 0, bytes.length);
        }

        public byte[] encode() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeBytes(out, new byte[]{(byte)this.flag});
            if (!this.isAdminModeEnabled()) {
                return out.toByteArray();
            }
            this.writeBytes(out, this.adminListCellTypeId);
            if (this.isAnyoneCanPayModeEnabled()) {
                this.writeBytes(out, new byte[]{this.minimumCKBExponentInAcp.byteValue()});
                if (this.minimumSUDTExponentInAcp == null) {
                    return out.toByteArray();
                }
            } else {
                return out.toByteArray();
            }
            this.writeBytes(out, new byte[]{this.minimumSUDTExponentInAcp.byteValue()});
            if (!this.isTimeLockModeEnabled()) {
                return out.toByteArray();
            }
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(this.sinceForTimeLock);
            this.writeBytes(out, buffer.array());
            if (this.isSupplyModeEnabled()) {
                this.writeBytes(out, this.typeScriptHashForSupply);
            }
            return out.toByteArray();
        }

        public boolean isAdminModeEnabled() {
            return (this.flag & 1) != 0;
        }

        public boolean isAnyoneCanPayModeEnabled() {
            return (this.flag & 2) != 0;
        }

        public boolean isTimeLockModeEnabled() {
            return (this.flag & 4) != 0;
        }

        public boolean isSupplyModeEnabled() {
            return (this.flag & 8) != 0;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }

        public byte[] getAdminListCellTypeId() {
            return this.adminListCellTypeId;
        }

        public void setAdminListCellTypeId(byte[] adminListCellTypeId) {
            this.adminListCellTypeId = adminListCellTypeId;
        }

        public Integer getMinimumCKBExponentInAcp() {
            return this.minimumCKBExponentInAcp;
        }

        public void setMinimumCKBExponentInAcp(Integer minimumCKBExponentInAcp) {
            this.minimumCKBExponentInAcp = minimumCKBExponentInAcp;
        }

        public Integer getMinimumSUDTExponentInAcp() {
            return this.minimumSUDTExponentInAcp;
        }

        public void setMinimumSUDTExponentInAcp(Integer minimumSUDTExponentInAcp) {
            this.minimumSUDTExponentInAcp = minimumSUDTExponentInAcp;
        }

        public Long getSinceForTimeLock() {
            return this.sinceForTimeLock;
        }

        public void setSinceForTimeLock(Long sinceForTimeLock) {
            this.sinceForTimeLock = sinceForTimeLock;
        }

        public byte[] getTypeScriptHashForSupply() {
            return this.typeScriptHashForSupply;
        }

        public void setTypeScriptHashForSupply(byte[] typeScriptHashForSupply) {
            this.typeScriptHashForSupply = typeScriptHashForSupply;
        }
    }

    public static class Authentication {
        private static int AUTH_CONTENT_LENGTH = 20;
        private AuthFlag flag;
        private byte[] authContent;

        public AuthFlag getFlag() {
            return this.flag;
        }

        public void setFlag(AuthFlag flag) {
            this.flag = flag;
        }

        public byte[] getAuthContent() {
            return this.authContent;
        }

        public void setAuthContent(byte[] authContent) {
            this.authContent = authContent;
        }

        public static Authentication decode(byte[] args) {
            Authentication authentication = new Authentication();
            authentication.flag = AuthFlag.valueOf(args[0]);
            authentication.authContent = new byte[AUTH_CONTENT_LENGTH];
            System.arraycopy(args, 1, authentication.authContent, 0, AUTH_CONTENT_LENGTH);
            return authentication;
        }

        public byte[] encode() {
            byte[] encoded = new byte[21];
            encoded[0] = this.flag.getValue();
            System.arraycopy(this.authContent, 0, encoded, 1, AUTH_CONTENT_LENGTH);
            return encoded;
        }
    }
}

