/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.signer;

import java.util.Arrays;
import java.util.List;
import org.nervos.ckb.crypto.Blake2b;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.sign.Context;
import org.nervos.ckb.sign.ScriptGroup;
import org.nervos.ckb.sign.ScriptSigner;
import org.nervos.ckb.sign.omnilock.OmnilockArgs;
import org.nervos.ckb.sign.omnilock.OmnilockIdentity;
import org.nervos.ckb.sign.omnilock.OmnilockWitnessLock;
import org.nervos.ckb.sign.signer.Secp256k1Blake160MultisigAllSigner;
import org.nervos.ckb.sign.signer.Secp256k1Blake160SighashAllSigner;
import org.nervos.ckb.type.CellDep;
import org.nervos.ckb.type.Transaction;
import org.nervos.ckb.type.WitnessArgs;

public class OmnilockSigner
implements ScriptSigner {
    @Override
    public boolean signTransaction(Transaction transaction, ScriptGroup scriptGroup, Context context) {
        OmnilockWitnessLock omnilockWitnessLock;
        if (!(context.getPayload() instanceof Configuration)) {
            return false;
        }
        byte[] args = scriptGroup.getScript().args;
        Configuration config = (Configuration)context.getPayload();
        if (!Arrays.equals(args, config.getOmnilockArgs().encode())) {
            return false;
        }
        List<byte[]> witnesses = transaction.witnesses;
        int index = scriptGroup.getInputIndices().get(0);
        WitnessArgs witnessArgs = WitnessArgs.unpack(witnesses.get(index));
        switch (config.getMode()) {
            case AUTH: {
                omnilockWitnessLock = OmnilockSigner.signForAuthMode(transaction, scriptGroup, context.getKeyPair(), config);
                break;
            }
            case ADMINISTRATOR: {
                omnilockWitnessLock = OmnilockSigner.signForAdministratorMode(transaction, scriptGroup, context.getKeyPair(), config);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Omnilock mode " + (Object)((Object)config.getMode()));
            }
        }
        if (omnilockWitnessLock != null) {
            witnessArgs.setLock(omnilockWitnessLock.pack().toByteArray());
            witnesses.set(index, witnessArgs.pack().toByteArray());
            return true;
        }
        return false;
    }

    private static OmnilockWitnessLock signForAuthMode(Transaction transaction, ScriptGroup scriptGroup, ECKeyPair keyPair, Configuration configuration) {
        byte[] authArgs = Arrays.copyOfRange(scriptGroup.getScript().args, 1, 21);
        int firstIndex = scriptGroup.getInputIndices().get(0);
        byte[] firstWitness = transaction.witnesses.get(firstIndex);
        WitnessArgs witnessArgs = WitnessArgs.unpack(firstWitness);
        OmnilockWitnessLock omnilockWitnessLock = new OmnilockWitnessLock();
        switch (configuration.getOmnilockArgs().getAuthenticationArgs().getFlag()) {
            case CKB_SECP256K1_BLAKE160: {
                byte[] hash = Blake2b.digest((byte[])keyPair.getEncodedPublicKey(true));
                hash = Arrays.copyOfRange(hash, 0, 20);
                if (!Arrays.equals(authArgs, hash)) {
                    return null;
                }
                omnilockWitnessLock.setSignature(new byte[65]);
                witnessArgs.setLock(new byte[omnilockWitnessLock.pack().toByteArray().length]);
                byte[] witnessPlaceholder = witnessArgs.pack().toByteArray();
                byte[] signature = Secp256k1Blake160SighashAllSigner.signTransaction(transaction, scriptGroup, witnessPlaceholder, keyPair);
                omnilockWitnessLock.setSignature(signature);
                break;
            }
            case ETHEREUM: {
                throw new UnsupportedOperationException("Ethereum");
            }
            case EOS: {
                throw new UnsupportedOperationException("EOS");
            }
            case TRON: {
                throw new UnsupportedOperationException("TRON");
            }
            case BITCOIN: {
                throw new UnsupportedOperationException("Bitcoin");
            }
            case DOGECOIN: {
                throw new UnsupportedOperationException("Dogecoin");
            }
            case CKB_MULTI_SIG: {
                Secp256k1Blake160MultisigAllSigner.MultisigScript multisigScript = configuration.getMultisigScript();
                if (multisigScript == null || !Arrays.equals(authArgs, multisigScript.computeHash())) {
                    return null;
                }
                boolean inMultisigScript = false;
                for (byte[] v : multisigScript.getKeysHashes()) {
                    byte[] hash = Blake2b.digest((byte[])keyPair.getEncodedPublicKey(true));
                    if (!Arrays.equals(v, hash = Arrays.copyOfRange(hash, 0, 20))) continue;
                    inMultisigScript = true;
                    break;
                }
                if (!inMultisigScript) {
                    return null;
                }
                WitnessArgs witnessArgsPlaceholder = WitnessArgs.unpack(firstWitness);
                omnilockWitnessLock.setSignature(multisigScript.witnessEmptyPlaceholderInLock());
                witnessArgsPlaceholder.setLock(omnilockWitnessLock.packAsEmptyPlaceholder());
                byte[] witnessPlaceholder = witnessArgsPlaceholder.pack().toByteArray();
                byte[] signature = Secp256k1Blake160SighashAllSigner.signTransaction(transaction, scriptGroup, witnessPlaceholder, keyPair);
                byte[] lockBytes = witnessArgs.getLock();
                byte[] oldSignature = OmnilockSigner.isEmpty(lockBytes, 0, lockBytes.length) ? multisigScript.witnessPlaceholderInLock() : OmnilockWitnessLock.unpack(lockBytes).getSignature();
                signature = OmnilockSigner.setSignatureToWitness(oldSignature, signature, multisigScript);
                omnilockWitnessLock.setSignature(signature);
                break;
            }
            case LOCK_SCRIPT_HASH: {
                break;
            }
            case EXEC: {
                throw new UnsupportedOperationException("Exec");
            }
            case DYNAMIC_LINKING: {
                throw new UnsupportedOperationException("Dynamic linking");
            }
            default: {
                throw new IllegalArgumentException("Unknown auth flag " + configuration.getOmnilockArgs().getOmniArgs().getFlag());
            }
        }
        return omnilockWitnessLock;
    }

    private static byte[] setSignatureToWitness(byte[] signatures, byte[] signature, Secp256k1Blake160MultisigAllSigner.MultisigScript multisigScript) {
        int offset = multisigScript.encode().length;
        for (int i = 0; i < multisigScript.getThreshold(); ++i) {
            if (OmnilockSigner.isEmpty(signatures, offset, 65)) {
                System.arraycopy(signature, 0, signatures, offset, 65);
                break;
            }
            offset += 65;
        }
        return signatures;
    }

    private static boolean isEmpty(byte[] lock, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            if (lock[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static OmnilockWitnessLock signForAdministratorMode(Transaction transaction, ScriptGroup scriptGroup, ECKeyPair keyPair, Configuration configuration) {
        byte[] signature = null;
        switch (configuration.getOmnilockIdentity().getIdentity().getFlag()) {
            case CKB_SECP256K1_BLAKE160: {
                throw new UnsupportedOperationException("CKB_SECP256K1_BLAKE160");
            }
            case LOCK_SCRIPT_HASH: {
                break;
            }
        }
        OmnilockWitnessLock omnilockWitnessLock = new OmnilockWitnessLock();
        omnilockWitnessLock.setOmnilockIdentity(configuration.getOmnilockIdentity());
        omnilockWitnessLock.setSignature(signature);
        return omnilockWitnessLock;
    }

    public static class Configuration {
        private OmnilockArgs omnilockArgs;
        private Mode mode;
        private Secp256k1Blake160MultisigAllSigner.MultisigScript multisigScript;
        private CellDep adminListCell;
        private OmnilockIdentity omnilockIdentity;

        public Configuration() {
        }

        public Configuration(OmnilockArgs omnilockArgs, Mode mode) {
            this.omnilockArgs = omnilockArgs;
            this.mode = mode;
        }

        public OmnilockArgs getOmnilockArgs() {
            return this.omnilockArgs;
        }

        public void setOmnilockArgs(OmnilockArgs omnilockArgs) {
            this.omnilockArgs = omnilockArgs;
        }

        public Mode getMode() {
            return this.mode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }

        public Secp256k1Blake160MultisigAllSigner.MultisigScript getMultisigScript() {
            return this.multisigScript;
        }

        public void setMultisigScript(Secp256k1Blake160MultisigAllSigner.MultisigScript multisigScript) {
            this.multisigScript = multisigScript;
        }

        public CellDep getAdminListCell() {
            return this.adminListCell;
        }

        public void setAdminListCell(CellDep adminListCell) {
            this.adminListCell = adminListCell;
        }

        public OmnilockIdentity getOmnilockIdentity() {
            return this.omnilockIdentity;
        }

        public void setOmnilockIdentity(OmnilockIdentity omnilockIdentity) {
            this.omnilockIdentity = omnilockIdentity;
        }

        public static enum Mode {
            AUTH,
            ADMINISTRATOR;

        }
    }
}

