/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.type;

import java.util.Arrays;
import org.nervos.ckb.utils.MoleculeConverter;

public class WitnessArgs {
    public static int SECP256K1_BLAKE160_WITNESS_BYTES_SIZE = 170;
    private byte[] lock;
    private byte[] inputType;
    private byte[] outputType;

    public WitnessArgs() {
    }

    public WitnessArgs(int lockLength) {
        this.lock = new byte[lockLength];
    }

    public WitnessArgs(byte[] lock) {
        this.setLock(lock);
    }

    public byte[] getLock() {
        return this.lock;
    }

    public void setLock(byte[] lock) {
        this.lock = lock;
    }

    public byte[] getInputType() {
        return this.inputType;
    }

    public void setInputType(byte[] inputType) {
        this.inputType = inputType;
    }

    public byte[] getOutputType() {
        return this.outputType;
    }

    public void setOutputType(byte[] outputType) {
        this.outputType = outputType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WitnessArgs that = (WitnessArgs)o;
        if (!Arrays.equals(this.lock, that.lock)) {
            return false;
        }
        if (!Arrays.equals(this.inputType, that.inputType)) {
            return false;
        }
        return Arrays.equals(this.outputType, that.outputType);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.lock);
        result = 31 * result + Arrays.hashCode(this.inputType);
        result = 31 * result + Arrays.hashCode(this.outputType);
        return result;
    }

    public org.nervos.ckb.type.concrete.WitnessArgs pack() {
        return org.nervos.ckb.type.concrete.WitnessArgs.builder().setLock(this.getLock() != null ? MoleculeConverter.packBytes(this.getLock()) : null).setInputType(this.getInputType() != null ? MoleculeConverter.packBytes(this.getInputType()) : null).setOutputType(this.getOutputType() != null ? MoleculeConverter.packBytes(this.getOutputType()) : null).build();
    }

    public static WitnessArgs unpack(byte[] in) {
        org.nervos.ckb.type.concrete.WitnessArgs moleculeWitnessArgs = org.nervos.ckb.type.concrete.WitnessArgs.builder((byte[])in).build();
        WitnessArgs witnessArgs = new WitnessArgs();
        witnessArgs.setLock(moleculeWitnessArgs.getLock() != null ? moleculeWitnessArgs.getLock().getItems() : null);
        witnessArgs.setInputType(moleculeWitnessArgs.getInputType() != null ? moleculeWitnessArgs.getInputType().getItems() : null);
        witnessArgs.setOutputType(moleculeWitnessArgs.getOutputType() != null ? moleculeWitnessArgs.getOutputType().getItems() : null);
        return witnessArgs;
    }

    public static enum Type {
        LOCK,
        INPUT_TYPE,
        OUTPUT_TYPE;

    }
}

