/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.omnilock;

import java.util.ArrayList;
import java.util.Arrays;
import org.nervos.ckb.sign.omnilock.OmnilockIdentity;
import org.nervos.ckb.sign.omnilock.molecule.Auth;
import org.nervos.ckb.sign.omnilock.molecule.Identity;
import org.nervos.ckb.sign.omnilock.molecule.OmniLockWitnessLock;
import org.nervos.ckb.sign.omnilock.molecule.SmtProof;
import org.nervos.ckb.sign.omnilock.molecule.SmtProofEntry;
import org.nervos.ckb.sign.omnilock.molecule.SmtProofEntryVec;
import org.nervos.ckb.utils.MoleculeConverter;

public class OmnilockWitnessLock {
    private byte[] signature;
    private OmnilockIdentity omnilockIdentity;
    private byte[] preimage;

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public OmnilockIdentity getOmnilockIdentity() {
        return this.omnilockIdentity;
    }

    public void setOmnilockIdentity(OmnilockIdentity omnilockIdentity) {
        this.omnilockIdentity = omnilockIdentity;
    }

    public byte[] getPreimage() {
        return this.preimage;
    }

    public void setPreimage(byte[] preimage) {
        this.preimage = preimage;
    }

    public OmniLockWitnessLock pack() {
        OmniLockWitnessLock.Builder moleculeLock = OmniLockWitnessLock.builder();
        if (this.signature != null) {
            moleculeLock.setSignature(MoleculeConverter.packBytes(this.signature));
        }
        if (this.preimage != null) {
            moleculeLock.setPreimage(MoleculeConverter.packBytes(this.preimage));
        }
        if (this.omnilockIdentity != null) {
            Identity.Builder identityBuilder = Identity.builder();
            Auth.Builder authBuilder = Auth.builder(this.omnilockIdentity.getIdentity().encode());
            identityBuilder.setIdentity(authBuilder.build());
            SmtProofEntryVec.Builder smtProofEntryVec = SmtProofEntryVec.builder();
            for (OmnilockIdentity.SmtProofEntry s : this.omnilockIdentity.getProofs()) {
                smtProofEntryVec.add(this.packSmtProofEntry(s));
            }
            identityBuilder.setProofs(smtProofEntryVec.build());
            moleculeLock.setOmniIdentity(identityBuilder.build());
        }
        return moleculeLock.build();
    }

    public byte[] packAsEmptyPlaceholder() {
        return new byte[this.pack().toByteArray().length];
    }

    public static OmnilockWitnessLock unpack(byte[] in) {
        if (in == null) {
            return null;
        }
        OmniLockWitnessLock moleculeOmniLockWitnessLock = OmniLockWitnessLock.builder(in).build();
        OmnilockWitnessLock omnilockWitnessLock = new OmnilockWitnessLock();
        if (moleculeOmniLockWitnessLock.getPreimage() != null) {
            omnilockWitnessLock.setPreimage(moleculeOmniLockWitnessLock.getPreimage().toByteArray());
        }
        if (moleculeOmniLockWitnessLock.getSignature() != null) {
            omnilockWitnessLock.setSignature(moleculeOmniLockWitnessLock.getSignature().getItems());
        }
        if (moleculeOmniLockWitnessLock.getOmniIdentity() != null) {
            OmnilockIdentity identity = new OmnilockIdentity();
            ArrayList<OmnilockIdentity.SmtProofEntry> proofs = new ArrayList<OmnilockIdentity.SmtProofEntry>();
            Identity moleculeIdentity = moleculeOmniLockWitnessLock.getOmniIdentity();
            for (int i = 0; i < moleculeIdentity.getProofs().getSize(); ++i) {
                SmtProofEntry moleculeSmtProofEntry = moleculeIdentity.getProofs().get(i);
                OmnilockIdentity.SmtProofEntry smtProofEntry = new OmnilockIdentity.SmtProofEntry();
                smtProofEntry.setMask(moleculeSmtProofEntry.getMask());
                smtProofEntry.setSmtProof(moleculeSmtProofEntry.getProof().toByteArray());
                proofs.add(smtProofEntry);
            }
            byte[] bytes = moleculeIdentity.getIdentity().toByteArray();
            omnilockWitnessLock.setOmnilockIdentity(identity);
            OmnilockIdentity.Auth auth = new OmnilockIdentity.Auth();
            auth.setFlag(OmnilockIdentity.OmnilockFlag.valueOf(bytes[0]));
            auth.setAuthContent(Arrays.copyOfRange(bytes, 1, 20));
            identity.setIdentity(auth);
            identity.setProofs(proofs);
            omnilockWitnessLock.setOmnilockIdentity(identity);
        }
        return omnilockWitnessLock;
    }

    public SmtProofEntry packSmtProofEntry(OmnilockIdentity.SmtProofEntry smtProofEntry) {
        SmtProofEntry.Builder builder = SmtProofEntry.builder();
        builder.setProof(SmtProof.builder(smtProofEntry.getSmtProof()).build());
        builder.setMask(smtProofEntry.getMask());
        return builder.build();
    }
}

