/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.omnilock.molecule;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.nervos.ckb.sign.omnilock.molecule.Identity;
import org.nervos.ckb.type.base.MoleculeException;
import org.nervos.ckb.type.base.MoleculeUtils;
import org.nervos.ckb.type.base.Table;
import org.nervos.ckb.type.concrete.Bytes;

public final class OmniLockWitnessLock
extends Table {
    public static int FIELD_COUNT = 3;
    private Bytes signature;
    private Identity omniIdentity;
    private Bytes preimage;

    private OmniLockWitnessLock() {
    }

    @Nullable
    public Bytes getSignature() {
        return this.signature;
    }

    @Nullable
    public Identity getOmniIdentity() {
        return this.omniIdentity;
    }

    @Nullable
    public Bytes getPreimage() {
        return this.preimage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@Nonnull byte[] buf) {
        return new Builder(buf);
    }

    static /* synthetic */ byte[] access$302(OmniLockWitnessLock x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    public static final class Builder {
        private Bytes signature;
        private Identity omniIdentity;
        private Bytes preimage;

        private Builder() {
            this.signature = null;
            this.omniIdentity = null;
            this.preimage = null;
        }

        private Builder(@Nonnull byte[] buf) {
            byte[] itemBuf;
            Objects.requireNonNull(buf);
            int size = MoleculeUtils.littleEndianBytes4ToInt((byte[])buf, (int)0);
            if (buf.length != size) {
                throw MoleculeException.invalidByteSize((int)size, (int)buf.length, OmniLockWitnessLock.class);
            }
            int[] offsets = MoleculeUtils.getOffsets((byte[])buf);
            if (offsets.length - 1 != FIELD_COUNT) {
                throw MoleculeException.invalidFieldCount((int)FIELD_COUNT, (int)(offsets.length - 1), OmniLockWitnessLock.class);
            }
            if (offsets[0] != offsets[1]) {
                itemBuf = Arrays.copyOfRange(buf, offsets[0], offsets[1]);
                this.signature = Bytes.builder((byte[])itemBuf).build();
            }
            if (offsets[1] != offsets[2]) {
                itemBuf = Arrays.copyOfRange(buf, offsets[1], offsets[2]);
                this.omniIdentity = Identity.builder(itemBuf).build();
            }
            if (offsets[2] != offsets[3]) {
                itemBuf = Arrays.copyOfRange(buf, offsets[2], offsets[3]);
                this.preimage = Bytes.builder((byte[])itemBuf).build();
            }
        }

        public Builder setSignature(@Nullable Bytes signature) {
            this.signature = signature;
            return this;
        }

        public Builder setOmniIdentity(@Nullable Identity omniIdentity) {
            this.omniIdentity = omniIdentity;
            return this;
        }

        public Builder setPreimage(@Nullable Bytes preimage) {
            this.preimage = preimage;
            return this;
        }

        public OmniLockWitnessLock build() {
            int i;
            int[] offsets = new int[FIELD_COUNT];
            offsets[0] = 4 + 4 * FIELD_COUNT;
            offsets[1] = offsets[0] + (this.signature == null ? 0 : this.signature.getSize());
            offsets[2] = offsets[1] + (this.omniIdentity == null ? 0 : this.omniIdentity.getSize());
            int[] fieldsSize = new int[FIELD_COUNT];
            fieldsSize[0] = this.signature == null ? 0 : this.signature.getSize();
            fieldsSize[1] = this.omniIdentity == null ? 0 : this.omniIdentity.getSize();
            fieldsSize[2] = this.preimage == null ? 0 : this.preimage.getSize();
            byte[][] fieldsBuf = new byte[FIELD_COUNT][];
            fieldsBuf[0] = this.signature == null ? new byte[]{} : this.signature.toByteArray();
            fieldsBuf[1] = this.omniIdentity == null ? new byte[]{} : this.omniIdentity.toByteArray();
            fieldsBuf[2] = this.preimage == null ? new byte[]{} : this.preimage.toByteArray();
            int size = 4 + 4 * FIELD_COUNT;
            for (int i2 = 0; i2 < FIELD_COUNT; ++i2) {
                size += fieldsSize[i2];
            }
            byte[] buf = new byte[size];
            MoleculeUtils.setInt((int)size, (byte[])buf, (int)0);
            int start = 4;
            for (i = 0; i < FIELD_COUNT; ++i) {
                MoleculeUtils.setInt((int)offsets[i], (byte[])buf, (int)start);
                start += 4;
            }
            for (i = 0; i < FIELD_COUNT; ++i) {
                MoleculeUtils.setBytes((byte[])fieldsBuf[i], (byte[])buf, (int)offsets[i]);
            }
            OmniLockWitnessLock t = new OmniLockWitnessLock();
            OmniLockWitnessLock.access$302(t, buf);
            t.signature = this.signature;
            t.omniIdentity = this.omniIdentity;
            t.preimage = this.preimage;
            return t;
        }
    }
}

