/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.type;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class MerkleProof {
    public List<Integer> indices;
    public List<byte[]> lemmas;

    public MerkleProof(List<Integer> indices, List<byte[]> lemmas) {
        this.indices = indices;
        this.lemmas = lemmas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerkleProof that = (MerkleProof)o;
        if (!Objects.equals(this.indices, that.indices)) {
            return false;
        }
        if (this.lemmas == that.lemmas) {
            return true;
        }
        if (this.lemmas == null || this.lemmas.size() != that.lemmas.size()) {
            return false;
        }
        Iterator<byte[]> this_it = this.lemmas.iterator();
        Iterator<byte[]> that_it = that.lemmas.iterator();
        while (this_it.hasNext()) {
            if (Arrays.equals(this_it.next(), that_it.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int lemmas_hashcode = 0;
        if (this.lemmas != null) {
            for (byte[] bytes : this.lemmas) {
                lemmas_hashcode = lemmas_hashcode * 31 + Arrays.hashCode(bytes);
            }
        }
        int indices_hashcode = this.indices == null ? 0 : this.indices.hashCode();
        return 31 * indices_hashcode + lemmas_hashcode;
    }
}

