/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import org.nervos.ckb.type.Transaction;

public class Calculator {
    private static final int SERIALIZED_TX_OFFSET_BYTE_SIZE = 4;
    private static final long RADIO = 1000L;
    private static final double DEFAULT_BYTES_PER_CYCLE = 1.705714E-4;

    public static int calculateTransactionSize(Transaction transaction) {
        byte[] bytes = transaction.pack().toByteArray();
        return bytes.length + 4;
    }

    private static long calculateTransactionFee(long transactionSize, long feeRate) {
        long base = transactionSize * feeRate;
        long fee = Long.divideUnsigned(base, 1000L);
        if (Long.compareUnsigned(fee * feeRate, base) < 0) {
            return fee + 1L;
        }
        return fee;
    }

    public static long calculateTransactionFee(Transaction transaction, long feeRate) {
        long txSize = Calculator.calculateTransactionSize(transaction);
        return Calculator.calculateTransactionFee(txSize, feeRate);
    }

    public static long calculateTransactionFee(Transaction transaction, long cycles, long feeRate) {
        long txSize = Math.max((long)Calculator.calculateTransactionSize(transaction), (long)((double)cycles * 1.705714E-4));
        return Calculator.calculateTransactionFee(txSize, feeRate);
    }
}

