/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import java.math.BigInteger;
import org.nervos.ckb.utils.Numeric;

public class EpochUtils {
    public static EpochInfo parse(byte[] epoch) {
        long epochLong = Numeric.toBigInt((byte[])epoch).longValue();
        long length = epochLong >> 40 & 0xFFFFL;
        long index = epochLong >> 24 & 0xFFFFL;
        long number = epochLong & 0xFFFFFFL;
        return new EpochInfo(length, index, number);
    }

    public static EpochInfo parse(long epoch) {
        return EpochUtils.parse(BigInteger.valueOf(epoch).toByteArray());
    }

    public static String generate(long length, long index, long number) {
        BigInteger epoch = BigInteger.valueOf((length << 40) + (index << 24) + number);
        return Numeric.toHexStringWithPrefix((BigInteger)epoch);
    }

    public static long generateSince(long length, long index, long number) {
        long since = 0x2000000000000000L;
        return since |= length << 40 | index << 24 | number;
    }

    public static class EpochInfo {
        public long length;
        public long index;
        public long number;

        public EpochInfo(long length, long index, long number) {
            this.length = length;
            this.index = index;
            this.number = number;
        }
    }
}

