/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import java.math.BigInteger;
import java.util.List;
import org.nervos.ckb.type.Block;
import org.nervos.ckb.type.CellInput;
import org.nervos.ckb.type.Transaction;
import org.nervos.ckb.type.concrete.Byte32;
import org.nervos.ckb.type.concrete.Byte32Vec;
import org.nervos.ckb.type.concrete.Bytes;
import org.nervos.ckb.type.concrete.BytesVec;
import org.nervos.ckb.type.concrete.CellDep;
import org.nervos.ckb.type.concrete.CellDepVec;
import org.nervos.ckb.type.concrete.CellInputVec;
import org.nervos.ckb.type.concrete.CellOutput;
import org.nervos.ckb.type.concrete.CellOutputVec;
import org.nervos.ckb.type.concrete.ProposalShortId;
import org.nervos.ckb.type.concrete.ProposalShortIdVec;
import org.nervos.ckb.type.concrete.TransactionVec;
import org.nervos.ckb.type.concrete.Uint128;
import org.nervos.ckb.type.concrete.Uint32;
import org.nervos.ckb.type.concrete.Uint64;
import org.nervos.ckb.type.concrete.UncleBlock;
import org.nervos.ckb.type.concrete.UncleBlockVec;
import org.nervos.ckb.utils.Numeric;

public class MoleculeConverter {
    public static byte[] toByteArrayLittleEndianUnsigned(BigInteger in, int length) {
        byte[] arr = Numeric.toBytesPadded((BigInteger)in, (int)length);
        byte[] out = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[arr.length - i - 1];
        }
        return out;
    }

    public static Uint32 packUint32(int in) {
        byte[] arr = new byte[4];
        arr[3] = (byte)(in >> 24);
        arr[2] = (byte)(in >> 16);
        arr[1] = (byte)(in >> 8);
        arr[0] = (byte)in;
        return Uint32.builder((byte[])arr).build();
    }

    public static Uint64 packUint64(long in) {
        byte[] arr = new byte[8];
        arr[7] = (byte)(in >> 56);
        arr[6] = (byte)(in >> 48);
        arr[5] = (byte)(in >> 40);
        arr[4] = (byte)(in >> 32);
        arr[3] = (byte)(in >> 24);
        arr[2] = (byte)(in >> 16);
        arr[1] = (byte)(in >> 8);
        arr[0] = (byte)in;
        return Uint64.builder((byte[])arr).build();
    }

    public static Uint128 packUint128(BigInteger in) {
        byte[] arr = MoleculeConverter.toByteArrayLittleEndianUnsigned(in, Uint128.SIZE);
        return Uint128.builder((byte[])arr).build();
    }

    public static Byte32 packByte32(byte[] in) {
        return Byte32.builder((byte[])in).build();
    }

    public static Bytes packBytes(byte[] in) {
        if (in == null) {
            return null;
        }
        return Bytes.builder().add(in).build();
    }

    public static BytesVec packBytesVec(List<byte[]> in) {
        Bytes[] arr = new Bytes[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = MoleculeConverter.packBytes(in.get(i));
        }
        return BytesVec.builder().add(arr).build();
    }

    public static Byte32Vec packByte32Vec(List<byte[]> in) {
        Byte32[] arr = new Byte32[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = MoleculeConverter.packByte32(in.get(i));
        }
        return Byte32Vec.builder().add(arr).build();
    }

    public static CellInputVec packCellInputVec(List<CellInput> in) {
        org.nervos.ckb.type.concrete.CellInput[] arr = new org.nervos.ckb.type.concrete.CellInput[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = in.get(i).pack();
        }
        return CellInputVec.builder().add(arr).build();
    }

    public static CellOutputVec packCellOutputVec(List<org.nervos.ckb.type.CellOutput> in) {
        CellOutput[] arr = new CellOutput[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = in.get(i).pack();
        }
        return CellOutputVec.builder().add(arr).build();
    }

    public static CellDepVec packCellDepVec(List<org.nervos.ckb.type.CellDep> in) {
        CellDep[] arr = new CellDep[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            arr[i] = in.get(i).pack();
        }
        return CellDepVec.builder().add(arr).build();
    }

    public static TransactionVec packTransactionVec(List<Transaction> transactions) {
        TransactionVec.Builder builder = TransactionVec.builder();
        org.nervos.ckb.type.concrete.Transaction[] packed_transactions = (org.nervos.ckb.type.concrete.Transaction[])transactions.stream().map(Transaction::pack).toArray(org.nervos.ckb.type.concrete.Transaction[]::new);
        builder.add(packed_transactions);
        return builder.build();
    }

    public static ProposalShortId packProposalShortId(byte[] shortId) {
        return ProposalShortId.builder().set(shortId).build();
    }

    public static ProposalShortIdVec packProposalShortIdVec(List<byte[]> shortIds) {
        ProposalShortIdVec.Builder builder = ProposalShortIdVec.builder();
        ProposalShortId[] packed_ids = (ProposalShortId[])shortIds.stream().map(MoleculeConverter::packProposalShortId).toArray(ProposalShortId[]::new);
        builder.add(packed_ids);
        return builder.build();
    }

    public static UncleBlock packUncleBlock(Block.Uncle uncle) {
        UncleBlock.Builder builder = UncleBlock.builder();
        builder.setHeader(uncle.header.pack());
        builder.setProposals(MoleculeConverter.packProposalShortIdVec(uncle.proposals));
        return builder.build();
    }

    public static UncleBlockVec packUncleBlockVec(List<Block.Uncle> uncles) {
        UncleBlockVec.Builder builder = UncleBlockVec.builder();
        UncleBlock[] packed_uncles = (UncleBlock[])uncles.stream().map(MoleculeConverter::packUncleBlock).toArray(UncleBlock[]::new);
        builder.add(packed_uncles);
        return builder.build();
    }
}

