/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nervos.ckb.Network;
import org.nervos.ckb.sign.Context;
import org.nervos.ckb.sign.Contexts;
import org.nervos.ckb.sign.ScriptGroup;
import org.nervos.ckb.sign.ScriptSigner;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.ckb.sign.signer.AcpSigner;
import org.nervos.ckb.sign.signer.OmnilockSigner;
import org.nervos.ckb.sign.signer.PwSigner;
import org.nervos.ckb.sign.signer.Secp256k1Blake160MultisigAllSigner;
import org.nervos.ckb.sign.signer.Secp256k1Blake160SighashAllSigner;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.ScriptType;
import org.nervos.ckb.type.Transaction;
import org.nervos.ckb.utils.Numeric;

public class TransactionSigner {
    private Map<Key, ScriptSigner> scriptSignerMap;
    private static TransactionSigner TESTNET_TRANSACTION_SIGNER = new TransactionSigner().registerLockScriptSigner(Script.SECP256K1_BLAKE160_SIGNHASH_ALL_CODE_HASH, (ScriptSigner)new Secp256k1Blake160SighashAllSigner()).registerLockScriptSigner(Script.SECP256K1_BLAKE160_MULTISIG_ALL_CODE_HASH_LEGACY, (ScriptSigner)new Secp256k1Blake160MultisigAllSigner()).registerLockScriptData1Signer(Script.SECP256K1_BLAKE160_MULTISIG_ALL_CODE_HASH_V2, new Secp256k1Blake160MultisigAllSigner()).registerLockScriptSigner(Script.ANY_CAN_PAY_CODE_HASH_TESTNET, (ScriptSigner)new AcpSigner()).registerLockScriptSigner(Script.PW_LOCK_CODE_HASH_TESTNET, (ScriptSigner)new PwSigner()).registerLockScriptSigner(Script.OMNILOCK_CODE_HASH_TESTNET, (ScriptSigner)new OmnilockSigner());
    private static TransactionSigner MAINNET_TRANSACTION_SIGNER = new TransactionSigner().registerLockScriptSigner(Script.SECP256K1_BLAKE160_SIGNHASH_ALL_CODE_HASH, (ScriptSigner)new Secp256k1Blake160SighashAllSigner()).registerLockScriptSigner(Script.SECP256K1_BLAKE160_MULTISIG_ALL_CODE_HASH_LEGACY, (ScriptSigner)new Secp256k1Blake160MultisigAllSigner()).registerLockScriptData1Signer(Script.SECP256K1_BLAKE160_MULTISIG_ALL_CODE_HASH_V2, new Secp256k1Blake160MultisigAllSigner()).registerLockScriptSigner(Script.ANY_CAN_PAY_CODE_HASH_MAINNET, (ScriptSigner)new AcpSigner()).registerLockScriptSigner(Script.PW_LOCK_CODE_HASH_MAINNET, (ScriptSigner)new PwSigner()).registerLockScriptSigner(Script.OMNILOCK_CODE_HASH_MAINNET, (ScriptSigner)new OmnilockSigner());

    public TransactionSigner() {
        this(new HashMap<Key, ScriptSigner>());
    }

    public TransactionSigner(Map<Key, ScriptSigner> scriptSignerMap) {
        this.scriptSignerMap = scriptSignerMap;
    }

    public TransactionSigner(TransactionSigner s) {
        this.scriptSignerMap = new HashMap<Key, ScriptSigner>();
        for (Map.Entry<Key, ScriptSigner> entry : s.scriptSignerMap.entrySet()) {
            this.scriptSignerMap.put(entry.getKey(), entry.getValue());
        }
    }

    public static TransactionSigner getInstance(Network network) {
        if (network == Network.TESTNET) {
            return TESTNET_TRANSACTION_SIGNER;
        }
        if (network == Network.MAINNET) {
            return MAINNET_TRANSACTION_SIGNER;
        }
        throw new IllegalArgumentException("Unsupported network: " + (Object)((Object)network));
    }

    private TransactionSigner register(byte[] codeHash, Script.HashType hashType, ScriptType scriptType, ScriptSigner scriptSigner) {
        this.scriptSignerMap.put(new Key(codeHash, hashType, scriptType), scriptSigner);
        return this;
    }

    public TransactionSigner registerTypeScriptSigner(byte[] codeHash, ScriptSigner scriptSigner) {
        return this.register(codeHash, Script.HashType.TYPE, ScriptType.TYPE, scriptSigner);
    }

    public TransactionSigner registerTypeScriptSigner(String codeHash, ScriptSigner scriptSigner) {
        return this.registerTypeScriptSigner(Numeric.hexStringToByteArray((String)codeHash), scriptSigner);
    }

    public TransactionSigner registerLockScriptSigner(byte[] codeHash, ScriptSigner scriptSigner) {
        return this.register(codeHash, Script.HashType.TYPE, ScriptType.LOCK, scriptSigner);
    }

    public TransactionSigner registerLockScriptData1Signer(byte[] codeHash, ScriptSigner scriptSigner) {
        return this.register(codeHash, Script.HashType.DATA1, ScriptType.LOCK, scriptSigner);
    }

    public TransactionSigner registerLockScriptSigner(String codeHash, ScriptSigner scriptSigner) {
        return this.registerLockScriptSigner(Numeric.hexStringToByteArray((String)codeHash), scriptSigner);
    }

    public Set<Integer> signTransaction(TransactionWithScriptGroups transaction, Context ... contexts) {
        return this.signTransaction(transaction, new HashSet<Context>(Arrays.asList(contexts)));
    }

    public Set<Integer> signTransaction(TransactionWithScriptGroups transaction, Set<Context> contexts) {
        HashSet<Integer> signedGroupsIndices = new HashSet<Integer>();
        if (contexts == null) {
            return signedGroupsIndices;
        }
        Transaction tx = transaction.getTxView();
        List<ScriptGroup> scriptGroups = transaction.getScriptGroups();
        block0: for (int i = 0; i < scriptGroups.size(); ++i) {
            ScriptGroup group = scriptGroups.get(i);
            if (!this.isValidScriptGroup(group)) {
                throw new IllegalArgumentException("invalid script group at index " + i);
            }
            Script script = group.getScript();
            ScriptSigner signer = this.scriptSignerMap.get(new Key(script.codeHash, script.hashType, group.getGroupType()));
            if (signer == null) continue;
            for (Context context : contexts) {
                if (!signer.signTransaction(tx, group, context)) continue;
                signedGroupsIndices.add(i);
                continue block0;
            }
        }
        return signedGroupsIndices;
    }

    public Set<Integer> signTransaction(TransactionWithScriptGroups transaction, String ... privateKeys) {
        Contexts contexts = new Contexts();
        contexts.addPrivateKeys(privateKeys);
        return this.signTransaction(transaction, contexts);
    }

    private boolean isValidScriptGroup(ScriptGroup scriptGroup) {
        if (scriptGroup == null || scriptGroup.getScript() == null || scriptGroup.getGroupType() == null) {
            return false;
        }
        boolean isEmptyInputIndices = scriptGroup.getInputIndices() == null || scriptGroup.getInputIndices().isEmpty();
        boolean isEmptyOutputIndices = scriptGroup.getOutputIndices() == null || scriptGroup.getOutputIndices().isEmpty();
        ScriptType scriptType = scriptGroup.getGroupType();
        if (scriptType == ScriptType.LOCK) {
            return !isEmptyInputIndices;
        }
        if (scriptType == ScriptType.TYPE) {
            return !isEmptyInputIndices || !isEmptyOutputIndices;
        }
        return false;
    }

    private static class Key {
        private byte[] codeHash;
        private Script.HashType hashType;
        private ScriptType scriptType;

        public Key(byte[] codeHash, Script.HashType hashType, ScriptType scriptType) {
            this.codeHash = codeHash;
            this.hashType = hashType;
            this.scriptType = scriptType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!Arrays.equals(this.codeHash, key.codeHash)) {
                return false;
            }
            if (this.hashType != key.hashType) {
                return false;
            }
            return this.scriptType == key.scriptType;
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.codeHash);
            result = 31 * result + this.hashType.hashCode();
            result = 31 * result + this.scriptType.hashCode();
            return result;
        }
    }
}

