/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.sign.omnilock.molecule;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.nervos.ckb.type.base.FixedVector;
import org.nervos.ckb.type.base.MoleculeException;
import org.nervos.ckb.type.base.MoleculeUtils;

public final class SmtProof
extends FixedVector {
    public static int ITEM_SIZE = 1;
    public static Class ITEM_TYPE = Byte.TYPE;
    private byte[] items;

    private SmtProof() {
    }

    public int getItemSize() {
        return ITEM_SIZE;
    }

    @Nonnull
    public byte get(int i) {
        return this.items[i];
    }

    @Nullable
    public byte[] getItems() {
        return this.items;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public Class getItemType() {
        return ITEM_TYPE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@Nonnull byte[] buf) {
        return new Builder(buf);
    }

    static /* synthetic */ byte[] access$302(SmtProof x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$402(SmtProof x0, byte[] x1) {
        x0.items = x1;
        return x1;
    }

    public static final class Builder {
        private byte[] items;

        private Builder() {
            this.items = new byte[0];
        }

        private Builder(@Nonnull byte[] buf) {
            Objects.requireNonNull(buf);
            int itemCount = MoleculeUtils.littleEndianBytes4ToInt((byte[])buf, (int)0);
            int size = 4 + itemCount * ITEM_SIZE;
            if (buf.length != size) {
                throw MoleculeException.invalidByteSize((int)size, (int)buf.length, SmtProof.class);
            }
            this.items = Arrays.copyOfRange(buf, 4, buf.length);
        }

        public Builder add(@Nonnull byte item) {
            Objects.requireNonNull(item);
            byte[] originalItems = this.items;
            this.items = new byte[originalItems.length + 1];
            System.arraycopy(originalItems, 0, this.items, 0, originalItems.length);
            this.items[this.items.length - 1] = item;
            return this;
        }

        public Builder add(@Nonnull byte[] items) {
            Objects.requireNonNull(items);
            byte[] originalItems = this.items;
            this.items = new byte[originalItems.length + items.length];
            System.arraycopy(originalItems, 0, this.items, 0, originalItems.length);
            System.arraycopy(items, 0, this.items, originalItems.length, items.length);
            return this;
        }

        public Builder set(int i, @Nonnull byte item) {
            Objects.requireNonNull(item);
            this.items[i] = item;
            return this;
        }

        public Builder set(@Nonnull byte[] items) {
            Objects.requireNonNull(items);
            this.items = items;
            return this;
        }

        public Builder remove(int i) {
            if (i < 0 || i >= this.items.length) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
            byte[] originalItems = this.items;
            this.items = new byte[originalItems.length - 1];
            System.arraycopy(originalItems, 0, this.items, 0, i);
            System.arraycopy(originalItems, i + 1, this.items, i, originalItems.length - i - 1);
            return this;
        }

        public SmtProof build() {
            byte[] buf = new byte[4 + this.items.length * ITEM_SIZE];
            MoleculeUtils.setInt((int)this.items.length, (byte[])buf, (int)0);
            MoleculeUtils.setBytes((byte[])this.items, (byte[])buf, (int)4);
            SmtProof v = new SmtProof();
            SmtProof.access$302(v, buf);
            SmtProof.access$402(v, this.items);
            return v;
        }
    }
}

