/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.indexer.CkbIndexerApi;
import org.nervos.ckb.indexer.IndexerCollector;
import org.nervos.ckb.indexer.NumberUtils;
import org.nervos.ckb.indexer.Receiver;
import org.nervos.ckb.indexer.ScriptGroupWithPrivateKeys;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.transaction.TransactionBuilder;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.fixed.UInt128;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Const;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Utils;
import org.nervos.ckb.utils.address.AddressParser;

public class SUDTExample {
    private static final BigInteger SUDT_ISSUE_SUM_AMOUNT = new BigInteger("1000000000000");
    private static final BigInteger SUDT_TRANSFER_AMOUNT = new BigInteger("60000000000");
    private static Api api;
    private static CkbIndexerApi ckbIndexerApi;
    private static final List<String> SendPrivateKeys;
    private static final List<String> SendAddresses;
    private static final List<String> ReceiveAddresses;
    public static Script sudtType;

    public static void main(String[] args) throws Exception {
        System.out.println("Before transferring, first sender's balance: " + SUDTExample.getBalance(SendAddresses.get(0)).divide(Const.UnitCKB).toString(10) + " CKB");
        System.out.println("Issue SUDT tx hash: " + SUDTExample.issue());
        Thread.sleep(30000L);
        System.out.println("Transfer SUDT tx hash: " + SUDTExample.transfer());
    }

    private static BigInteger getBalance(String address) throws IOException {
        return new IndexerCollector(api, ckbIndexerApi).getCapacity(address);
    }

    private static String issue() throws IOException {
        ArrayList<ScriptGroupWithPrivateKeys> scriptGroupWithPrivateKeysList = new ArrayList<ScriptGroupWithPrivateKeys>();
        TransactionBuilder txBuilder = new TransactionBuilder(api);
        IndexerCollector txUtils = new IndexerCollector(api, ckbIndexerApi);
        List<Receiver> receivers = Collections.singletonList(new Receiver(SendAddresses.get(0), Utils.ckbToShannon((long)2000L)));
        List<CellOutput> cellOutputs = txUtils.generateOutputs(receivers, SendAddresses.get(0));
        cellOutputs.get((int)0).type = sudtType;
        txBuilder.addOutputs(cellOutputs);
        txBuilder.setOutputsData(Arrays.asList(Numeric.toHexString((byte[])new UInt128(SUDT_ISSUE_SUM_AMOUNT).toBytes()), "0x"));
        txBuilder.addCellDep(new CellDep(new OutPoint("0xe12877ebd2c3c364dc46c5c992bcfaf4fee33fa13eebdf82c591fc9825aab769", "0x0"), "code"));
        BigInteger feeRate = BigInteger.valueOf(1024L);
        CollectResult collectResult = txUtils.collectInputs(SendAddresses, txBuilder.buildTx(), feeRate, 130);
        if (Numeric.toBigInt((String)collectResult.changeCapacity).compareTo(Const.MIN_CKB) >= 0) {
            cellOutputs.get((int)(cellOutputs.size() - 1)).capacity = collectResult.changeCapacity;
            txBuilder.setOutputs(cellOutputs);
        }
        int startIndex = 0;
        for (Object cellsWithAddress : collectResult.cellsWithAddresses) {
            txBuilder.addInputs(((CellsWithAddress)cellsWithAddress).inputs);
            for (int i = 0; i < ((CellsWithAddress)cellsWithAddress).inputs.size(); ++i) {
                txBuilder.addWitness(i == 0 ? new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") : "0x");
            }
            if (((CellsWithAddress)cellsWithAddress).inputs.size() <= 0) continue;
            scriptGroupWithPrivateKeysList.add(new ScriptGroupWithPrivateKeys(new ScriptGroup(NumberUtils.regionToList(startIndex, ((CellsWithAddress)cellsWithAddress).inputs.size())), Collections.singletonList(SendPrivateKeys.get(SendAddresses.indexOf(((CellsWithAddress)cellsWithAddress).address)))));
            startIndex += ((CellsWithAddress)cellsWithAddress).inputs.size();
        }
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(txBuilder.buildTx());
        for (ScriptGroupWithPrivateKeys scriptGroupWithPrivateKeys : scriptGroupWithPrivateKeysList) {
            signBuilder.sign(scriptGroupWithPrivateKeys.scriptGroup, scriptGroupWithPrivateKeys.privateKeys.get(0));
        }
        Transaction tx = signBuilder.buildTx();
        return api.sendTransaction(tx);
    }

    private static String transfer() throws IOException {
        ArrayList<ScriptGroupWithPrivateKeys> scriptGroupWithPrivateKeysList = new ArrayList<ScriptGroupWithPrivateKeys>();
        TransactionBuilder txBuilder = new TransactionBuilder(api);
        IndexerCollector txUtils = new IndexerCollector(api, ckbIndexerApi);
        List<Receiver> receivers = Collections.singletonList(new Receiver(ReceiveAddresses.get(0), Const.MIN_SUDT_CKB));
        List<CellOutput> cellOutputs = txUtils.generateOutputs(receivers, SendAddresses.get(0));
        cellOutputs.get((int)0).type = sudtType;
        txBuilder.addOutputs(cellOutputs);
        txBuilder.addCellDep(new CellDep(new OutPoint("0xe12877ebd2c3c364dc46c5c992bcfaf4fee33fa13eebdf82c591fc9825aab769", "0x0"), "code"));
        BigInteger feeRate = BigInteger.valueOf(1500L);
        CollectResult collectResult = txUtils.collectInputs(SendAddresses, txBuilder.buildTx(), feeRate, 130, sudtType);
        if (Numeric.toBigInt((String)collectResult.changeCapacity).compareTo(Const.MIN_CKB) >= 0) {
            cellOutputs.get((int)(cellOutputs.size() - 1)).capacity = collectResult.changeCapacity;
            cellOutputs.get((int)(cellOutputs.size() - 1)).type = sudtType;
            txBuilder.setOutputs(cellOutputs);
        }
        txBuilder.setOutputsData(Arrays.asList(Numeric.toHexString((byte[])new UInt128(SUDT_TRANSFER_AMOUNT).toBytes()), Numeric.toHexString((byte[])new UInt128(SUDT_ISSUE_SUM_AMOUNT.subtract(SUDT_TRANSFER_AMOUNT)).toBytes())));
        int startIndex = 0;
        for (Object cellsWithAddress : collectResult.cellsWithAddresses) {
            txBuilder.addInputs(((CellsWithAddress)cellsWithAddress).inputs);
            for (int i = 0; i < ((CellsWithAddress)cellsWithAddress).inputs.size(); ++i) {
                txBuilder.addWitness(i == 0 ? new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") : "0x");
            }
            if (((CellsWithAddress)cellsWithAddress).inputs.size() <= 0) continue;
            scriptGroupWithPrivateKeysList.add(new ScriptGroupWithPrivateKeys(new ScriptGroup(NumberUtils.regionToList(startIndex, ((CellsWithAddress)cellsWithAddress).inputs.size())), Collections.singletonList(SendPrivateKeys.get(SendAddresses.indexOf(((CellsWithAddress)cellsWithAddress).address)))));
            startIndex += ((CellsWithAddress)cellsWithAddress).inputs.size();
        }
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(txBuilder.buildTx());
        for (ScriptGroupWithPrivateKeys scriptGroupWithPrivateKeys : scriptGroupWithPrivateKeysList) {
            signBuilder.sign(scriptGroupWithPrivateKeys.scriptGroup, scriptGroupWithPrivateKeys.privateKeys.get(0));
        }
        Transaction tx = signBuilder.buildTx();
        return api.sendTransaction(tx);
    }

    static {
        SendPrivateKeys = Collections.singletonList("08730a367dfabcadb805d69e0e613558d5160eb8bab9d6e326980c2c46a05db2");
        SendAddresses = Collections.singletonList("ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqtyqlpwlx7ed68pftzv69wcvr5nxxqzzus2zxwa6");
        ReceiveAddresses = Collections.singletonList("ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqwgx292hnvmn68xf779vmzrshpmm6epn4c0cgwga");
        api = new Api("http://localhost:8114", false);
        ckbIndexerApi = new CkbIndexerApi("http://localhost:8116", true);
        Script senderScript = AddressParser.parse((String)SUDTExample.SendAddresses.get((int)0)).script;
        String sendLockHash = senderScript.computeHash();
        sudtType = new Script("0xc5e5dcf215925f7ef4dfaf5f4b4f105bc321c02776d6e7d52a1db3fcd9d011a4", sendLockHash, "type");
    }
}

