/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.address.AddressUtils;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.indexer.CkbIndexerApi;
import org.nervos.ckb.indexer.IndexerCollector;
import org.nervos.ckb.indexer.NumberUtils;
import org.nervos.ckb.indexer.Receiver;
import org.nervos.ckb.indexer.ScriptGroupWithPrivateKeys;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.transaction.TransactionBuilder;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Const;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Utils;

public class TransferAllBalanceWithCkbIndexerExample {
    private static Api api = new Api("http://localhost:8114", false);
    private static CkbIndexerApi ckbIndexerApi = new CkbIndexerApi("http://localhost:8116", false);
    private static List<String> SendPrivateKeys = Collections.singletonList("d00c06bfd800d27397002dca6fb0993d5ba6399b4238b2f29ee9deb97593d2bc");
    private static List<String> SendAddresses = Collections.singletonList("ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqwgx292hnvmn68xf779vmzrshpmm6epn4c0cgwga");
    private static List<String> ReceiveAddresses = Collections.singletonList("ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqtxfjvw09k4jwvefcaaufl6j8ja7rprugc6v4690");

    public static void main(String[] args) throws Exception {
        AddressUtils utils = new AddressUtils(Network.TESTNET);
        for (int i = 0; i < SendAddresses.size() - 1; ++i) {
            String testPublicKey = ECKeyPair.publicKeyFromPrivate((String)SendPrivateKeys.get(i));
            String address = SendAddresses.get(i);
            if (address.equals(utils.generateFromPublicKey(testPublicKey))) continue;
            System.out.println("Private key and address " + address + " are not matched");
            return;
        }
        System.out.println("Wait some time for ckb-indexer running");
        List<Receiver> receivers = Collections.singletonList(new Receiver(ReceiveAddresses.get(0), Utils.ckbToShannon((long)100L)));
        System.out.println("Before transferring, first sender's balance: " + TransferAllBalanceWithCkbIndexerExample.getBalance(SendAddresses.get(0)).divide(Const.UnitCKB).toString(10) + " CKB");
        String hash = TransferAllBalanceWithCkbIndexerExample.sendCapacity(receivers, null);
        System.out.println("Transaction hash: " + hash);
        Thread.sleep(30000L);
        System.out.println("After transferring, first sender's balance: " + TransferAllBalanceWithCkbIndexerExample.getBalance(SendAddresses.get(0)).divide(Const.UnitCKB).toString(10) + " CKB");
    }

    private static BigInteger getBalance(String address) throws IOException {
        return new IndexerCollector(api, ckbIndexerApi).getCapacity(address);
    }

    private static String sendCapacity(List<Receiver> receivers, String changeAddress) throws IOException {
        ArrayList<ScriptGroupWithPrivateKeys> scriptGroupWithPrivateKeysList = new ArrayList<ScriptGroupWithPrivateKeys>();
        TransactionBuilder txBuilder = new TransactionBuilder(api);
        IndexerCollector txUtils = new IndexerCollector(api, ckbIndexerApi);
        List<CellOutput> cellOutputs = txUtils.generateOutputs(receivers, changeAddress);
        txBuilder.addOutputs(cellOutputs);
        BigInteger feeRate = BigInteger.valueOf(1024L);
        CollectResult collectResult = txUtils.collectInputs(SendAddresses, txBuilder.buildTx(), feeRate, 130);
        if (Numeric.toBigInt((String)collectResult.changeCapacity).compareTo(BigInteger.ZERO) > 0) {
            cellOutputs.get((int)(cellOutputs.size() - 1)).capacity = collectResult.changeCapacity;
            txBuilder.setOutputs(cellOutputs);
        }
        int startIndex = 0;
        for (Object cellsWithAddress : collectResult.cellsWithAddresses) {
            txBuilder.addInputs(((CellsWithAddress)cellsWithAddress).inputs);
            for (int i = 0; i < ((CellsWithAddress)cellsWithAddress).inputs.size(); ++i) {
                txBuilder.addWitness(i == 0 ? new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") : "0x");
            }
            if (((CellsWithAddress)cellsWithAddress).inputs.size() <= 0) continue;
            scriptGroupWithPrivateKeysList.add(new ScriptGroupWithPrivateKeys(new ScriptGroup(NumberUtils.regionToList(startIndex, ((CellsWithAddress)cellsWithAddress).inputs.size())), Collections.singletonList(SendPrivateKeys.get(SendAddresses.indexOf(((CellsWithAddress)cellsWithAddress).address)))));
            startIndex += ((CellsWithAddress)cellsWithAddress).inputs.size();
        }
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(txBuilder.buildTx());
        for (ScriptGroupWithPrivateKeys scriptGroupWithPrivateKeys : scriptGroupWithPrivateKeysList) {
            signBuilder.sign(scriptGroupWithPrivateKeys.scriptGroup, scriptGroupWithPrivateKeys.privateKeys.get(0));
        }
        Transaction tx = signBuilder.buildTx();
        return api.sendTransaction(tx);
    }
}

