/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nervos.ckb.address.AddressUtils;
import org.nervos.ckb.address.CodeHashType;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.system.SystemContract;
import org.nervos.ckb.system.type.SystemScriptCell;
import org.nervos.ckb.transaction.LockUtils;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.cell.CellOutputWithOutPoint;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Calculator;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;

public class CellCollector {
    private Api api;

    public CellCollector(Api api) {
        this.api = api;
    }

    public Map<String, List<CellInput>> collectInputs(List<String> lockHashes, List<CellOutput> cellOutputs, BigInteger feeRate) throws IOException {
        ArrayList<String> cellOutputsData = new ArrayList<String>();
        for (int i = 0; i < cellOutputs.size() - 1; ++i) {
            int size = Serializer.serializeCellOutput((CellOutput)cellOutputs.get(i)).getLength();
            if (BigInteger.valueOf(size).compareTo(Numeric.toBigInt((String)cellOutputs.get((int)i).capacity)) > 0) {
                throw new IOException("Cell output serialize size must not be bigger than capacity");
            }
            cellOutputsData.add("0x");
        }
        SystemScriptCell systemScriptCell = SystemContract.getSystemSecpCell((Api)this.api);
        cellOutputsData.add("0x");
        Transaction transaction = new Transaction("0", Collections.singletonList(new CellDep(systemScriptCell.outPoint, "dep_group")), Collections.emptyList(), Collections.emptyList(), cellOutputs, cellOutputsData, Collections.emptyList());
        BigInteger transactionFee = this.calculateTxFee(transaction, feeRate);
        BigInteger inputsCapacity = BigInteger.ZERO;
        ArrayList<CellInput> cellInputs = new ArrayList<CellInput>();
        HashMap<String, List<CellInput>> lockInputsMap = new HashMap<String, List<CellInput>>();
        for (String lockHash : lockHashes) {
            lockInputsMap.put(lockHash, new ArrayList());
        }
        ArrayList<Witness> witnesses = new ArrayList<Witness>();
        CellOutput changeOutput = cellOutputs.get(cellOutputs.size() - 1);
        BigInteger changeOutputSize = BigInteger.valueOf(Serializer.serializeCellOutput((CellOutput)changeOutput).getLength());
        BigInteger needCapacity = BigInteger.ZERO;
        for (CellOutput cellOutput : cellOutputs) {
            needCapacity = needCapacity.add(Numeric.toBigInt((String)cellOutput.capacity));
        }
        List cellOutputList = new ArrayList();
        for (int index = 0; index < lockHashes.size(); ++index) {
            long toBlockNumber = this.api.getTipBlockNumber().longValue();
            long fromBlockNumber = 1L;
            while (fromBlockNumber <= toBlockNumber && inputsCapacity.compareTo(needCapacity.add(transactionFee)) < 0) {
                long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
                cellOutputList = this.api.getCellsByLockHash(lockHashes.get(index), BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
                if (cellOutputList.size() > 0) {
                    for (CellOutputWithOutPoint cellOutputWithOutPoint : cellOutputList) {
                        CellInput cellInput = new CellInput(cellOutputWithOutPoint.outPoint, "0x0");
                        inputsCapacity = inputsCapacity.add(Numeric.toBigInt((String)cellOutputWithOutPoint.capacity));
                        List cellInputList = (List)lockInputsMap.get(lockHashes.get(index));
                        cellInputList.add(cellInput);
                        cellInputs.add(cellInput);
                        witnesses.add(new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"));
                        transaction.inputs = cellInputs;
                        transaction.witnesses = witnesses;
                        transactionFee = this.calculateTxFee(transaction, feeRate);
                        BigInteger sumNeedCapacity = needCapacity.add(transactionFee).add(changeOutputSize);
                        if (inputsCapacity.compareTo(sumNeedCapacity) <= 0) continue;
                        cellOutputs.get((int)(cellOutputs.size() - 1)).capacity = Numeric.prependHexPrefix((String)inputsCapacity.subtract(needCapacity).subtract(transactionFee).toString(16));
                        break;
                    }
                }
                fromBlockNumber = currentToBlockNumber + 1L;
            }
        }
        if (inputsCapacity.compareTo(needCapacity.add(transactionFee)) < 0) {
            throw new IOException("Capacity not enough!");
        }
        return lockInputsMap;
    }

    private BigInteger calculateTxFee(Transaction transaction, BigInteger feeRate) {
        int txSize = Serializer.serializeTransaction((Transaction)transaction).toBytes().length;
        return Calculator.calculateTransactionFee((BigInteger)BigInteger.valueOf(txSize), (BigInteger)feeRate);
    }

    public BigInteger getCapacityWithAddress(String address) throws IOException {
        CodeHashType codeHashType = AddressUtils.parseAddressType((String)address);
        SystemScriptCell systemScriptCell = codeHashType == CodeHashType.BLAKE160 ? SystemContract.getSystemSecpCell((Api)this.api) : SystemContract.getSystemMultiSigCell((Api)this.api);
        Script lockScript = LockUtils.generateLockScriptWithAddress((String)address, (String)systemScriptCell.cellHash);
        return this.getCapacityWithLockHash(lockScript.computeHash());
    }

    public BigInteger getCapacityWithLockHash(String lockHash) throws IOException {
        BigInteger capacity = BigInteger.ZERO;
        long toBlockNumber = this.api.getTipBlockNumber().longValue();
        long fromBlockNumber = 1L;
        while (fromBlockNumber <= toBlockNumber) {
            long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
            List cellOutputs = this.api.getCellsByLockHash(lockHash, BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
            if (cellOutputs != null && cellOutputs.size() > 0) {
                for (CellOutputWithOutPoint output : cellOutputs) {
                    capacity = capacity.add(Numeric.toBigInt((String)output.capacity));
                }
            }
            fromBlockNumber = currentToBlockNumber + 1L;
        }
        return capacity;
    }
}

