/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nervos.ckb.address.AddressUtils;
import org.nervos.ckb.address.CodeHashType;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.system.SystemContract;
import org.nervos.ckb.system.type.SystemScriptCell;
import org.nervos.ckb.transaction.CellCollector;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.LockUtils;
import org.nervos.ckb.transaction.Receiver;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.utils.Numeric;

public class CollectUtils {
    private Api api;

    public CollectUtils(Api api) {
        this.api = api;
    }

    public List<CellsWithAddress> collectInputs(List<String> sendAddresses, List<CellOutput> cellOutputs, BigInteger feeRate) throws IOException {
        ArrayList<CellsWithAddress> cellsWithAddresses = new ArrayList<CellsWithAddress>();
        ArrayList<String> lockHashes = new ArrayList<String>();
        for (String address : sendAddresses) {
            CodeHashType codeHashType = AddressUtils.parseAddressType((String)address);
            SystemScriptCell systemScriptCell = this.getSystemScriptCell(codeHashType);
            lockHashes.add(LockUtils.generateLockScriptWithAddress((String)address, (String)systemScriptCell.cellHash).computeHash());
        }
        Map<String, List<CellInput>> lockInputMap = new CellCollector(this.api).collectInputs(lockHashes, cellOutputs, feeRate);
        for (Map.Entry<String, List<CellInput>> entry : lockInputMap.entrySet()) {
            cellsWithAddresses.add(new CellsWithAddress(entry.getValue(), sendAddresses.get(lockHashes.indexOf(entry.getKey()))));
        }
        return cellsWithAddresses;
    }

    public List<CellOutput> generateOutputs(List<Receiver> receivers, String changeAddress) throws IOException {
        ArrayList<CellOutput> cellOutputs = new ArrayList<CellOutput>();
        for (Receiver receiver : receivers) {
            String blake160 = AddressUtils.parse((String)receiver.address);
            CodeHashType codeHashType = AddressUtils.parseAddressType((String)receiver.address);
            cellOutputs.add(new CellOutput(Numeric.prependHexPrefix((String)receiver.capacity.toString(16)), new Script(this.getSystemScriptCell((CodeHashType)codeHashType).cellHash, Numeric.prependHexPrefix((String)blake160), "type")));
        }
        BigInteger needCapacity = BigInteger.ZERO;
        for (Receiver receiver : receivers) {
            needCapacity = needCapacity.add(receiver.capacity);
        }
        String string = AddressUtils.parse((String)changeAddress);
        CodeHashType codeHashType = AddressUtils.parseAddressType((String)changeAddress);
        cellOutputs.add(new CellOutput("0x0", new Script(this.getSystemScriptCell((CodeHashType)codeHashType).cellHash, Numeric.prependHexPrefix((String)string), "type")));
        return cellOutputs;
    }

    private SystemScriptCell getSystemScriptCell(CodeHashType codeHashType) throws IOException {
        if (codeHashType == CodeHashType.BLAKE160) {
            return SystemContract.getSystemSecpCell((Api)this.api);
        }
        return SystemContract.getSystemMultiSigCell((Api)this.api);
    }
}

