/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellCollector;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectUtils;
import org.nervos.ckb.transaction.NumberUtils;
import org.nervos.ckb.transaction.Receiver;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.ScriptGroupWithPrivateKeys;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.transaction.TransactionBuilder;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;

public class SingleKeySingleSigTxExample {
    private static final String NODE_URL = "http://localhost:8114";
    private static final BigInteger UnitCKB = new BigInteger("100000000");
    private static Api api;
    private static List<String> ReceiveAddresses;
    private static String MinerPrivateKey;
    private static String MinerAddress;

    public static void main(String[] args) throws Exception {
        List<Receiver> receivers = Arrays.asList(new Receiver(ReceiveAddresses.get(0), new BigInteger("8000").multiply(UnitCKB)), new Receiver(ReceiveAddresses.get(1), new BigInteger("9000").multiply(UnitCKB)));
        System.out.println("Before transfer, miner's balance: " + SingleKeySingleSigTxExample.getBalance(MinerAddress).divide(UnitCKB).toString(10) + " CKB");
        System.out.println("Before transfer, first receiver's balance: " + SingleKeySingleSigTxExample.getBalance(ReceiveAddresses.get(0)).divide(UnitCKB).toString(10) + " CKB");
        String hash = SingleKeySingleSigTxExample.sendCapacity(receivers, MinerAddress);
        System.out.println("Transaction hash: " + hash);
        Thread.sleep(30000L);
        System.out.println("After transfer, receiver's balance: " + SingleKeySingleSigTxExample.getBalance(ReceiveAddresses.get(0)).divide(UnitCKB).toString(10) + " CKB");
    }

    private static BigInteger getBalance(String address) throws IOException {
        CellCollector cellCollector = new CellCollector(api);
        return cellCollector.getCapacityWithAddress(address);
    }

    private static String sendCapacity(List<Receiver> receivers, String changeAddress) throws IOException {
        BigInteger needCapacity = BigInteger.ZERO;
        ArrayList<ScriptGroupWithPrivateKeys> scriptGroupWithPrivateKeysList = new ArrayList<ScriptGroupWithPrivateKeys>();
        for (Receiver receiver : receivers) {
            needCapacity = needCapacity.add(receiver.capacity);
        }
        TransactionBuilder txBuilder = new TransactionBuilder(api);
        CollectUtils txUtils = new CollectUtils(api);
        List<CellOutput> cellOutputs = txUtils.generateOutputs(receivers, changeAddress);
        txBuilder.addOutputs(cellOutputs);
        BigInteger feeRate = BigInteger.valueOf(10000L);
        List<CellsWithAddress> cellsWithAddresses = txUtils.collectInputs(Collections.singletonList(MinerAddress), cellOutputs, feeRate);
        int startIndex = 0;
        for (CellsWithAddress cellsWithAddress : cellsWithAddresses) {
            txBuilder.addInputs(cellsWithAddress.inputs);
            for (CellInput cellInput : cellsWithAddress.inputs) {
                txBuilder.addWitness(new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"));
            }
            scriptGroupWithPrivateKeysList.add(new ScriptGroupWithPrivateKeys(new ScriptGroup(NumberUtils.regionToList(startIndex, cellsWithAddress.inputs.size())), Collections.singletonList(MinerPrivateKey)));
        }
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(txBuilder.buildTx());
        for (ScriptGroupWithPrivateKeys scriptGroupWithPrivateKeys : scriptGroupWithPrivateKeysList) {
            signBuilder.sign(scriptGroupWithPrivateKeys.scriptGroup, scriptGroupWithPrivateKeys.privateKeys.get(0));
        }
        return api.sendTransaction(signBuilder.buildTx());
    }

    static {
        MinerPrivateKey = "e79f3207ea4980b7fed79956d5934249ceac4751a4fae01a0f7c4a96884bc4e3";
        MinerAddress = "ckt1qyqrdsefa43s6m882pcj53m4gdnj4k440axqswmu83";
        api = new Api(NODE_URL, false);
        ReceiveAddresses = Arrays.asList("ckt1qyqxgp7za7dajm5wzjkye52asc8fxvvqy9eqlhp82g", "ckt1qyqtnz38fht9nvmrfdeunrhdtp29n0gagkps4duhek");
    }
}

