/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.system.SystemContract;
import org.nervos.ckb.system.type.SystemScriptCell;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.cell.CellOutputWithOutPoint;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Calculator;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressParser;

public class CellCollector {
    private Api api;

    public CellCollector(Api api) {
        this.api = api;
    }

    public Map<String, List<CellInput>> collectInputs(List<String> lockHashes, List<CellOutput> cellOutputs, BigInteger feeRate, int initialLength) throws IOException {
        ArrayList<String> cellOutputsData = new ArrayList<String>();
        for (int i = 0; i < cellOutputs.size() - 1; ++i) {
            BigInteger size = cellOutputs.get(i).occupiedCapacity("0x");
            if (size.compareTo(Numeric.toBigInt((String)cellOutputs.get((int)i).capacity)) > 0) {
                throw new IOException("Cell output byte size must not be bigger than capacity");
            }
            cellOutputsData.add("0x");
        }
        SystemScriptCell systemScriptCell = SystemContract.getSystemSecpCell((Api)this.api);
        cellOutputsData.add("0x");
        Transaction transaction = new Transaction("0", Collections.singletonList(new CellDep(systemScriptCell.outPoint, "dep_group")), Collections.emptyList(), Collections.emptyList(), cellOutputs, cellOutputsData, Collections.emptyList());
        BigInteger inputsCapacity = BigInteger.ZERO;
        ArrayList<CellInput> cellInputs = new ArrayList<CellInput>();
        HashMap<String, List<CellInput>> lockInputsMap = new HashMap<String, List<CellInput>>();
        for (String lockHash : lockHashes) {
            lockInputsMap.put(lockHash, new ArrayList());
        }
        ArrayList<String> witnesses = new ArrayList<String>();
        CellOutput changeOutput = cellOutputs.get(cellOutputs.size() - 1);
        BigInteger needCapacity = BigInteger.ZERO;
        for (CellOutput cellOutput : cellOutputs) {
            needCapacity = needCapacity.add(Numeric.toBigInt((String)cellOutput.capacity));
        }
        for (int index = 0; index < lockHashes.size(); ++index) {
            long toBlockNumber = this.api.getTipBlockNumber().longValue();
            long fromBlockNumber = 1L;
            while (fromBlockNumber <= toBlockNumber && inputsCapacity.compareTo(needCapacity.add(this.calculateTxFee(transaction, feeRate))) < 0) {
                long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
                List cellOutputList = this.api.getCellsByLockHash(lockHashes.get(index), BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
                for (CellOutputWithOutPoint cellOutputWithOutPoint : cellOutputList) {
                    CellInput cellInput = new CellInput(cellOutputWithOutPoint.outPoint, "0x0");
                    inputsCapacity = inputsCapacity.add(Numeric.toBigInt((String)cellOutputWithOutPoint.capacity));
                    List cellInputList = (List)lockInputsMap.get(lockHashes.get(index));
                    cellInputList.add(cellInput);
                    cellInputs.add(cellInput);
                    witnesses.add("0x");
                    transaction.inputs = cellInputs;
                    transaction.witnesses = witnesses;
                    BigInteger sumNeedCapacity = needCapacity.add(this.calculateTxFee(transaction, feeRate)).add(this.calculateOutputSize(changeOutput));
                    if (inputsCapacity.compareTo(sumNeedCapacity) <= 0) continue;
                    int witnessIndex = 0;
                    for (String lockHash : lockHashes) {
                        if (((List)lockInputsMap.get(lockHash)).size() == 0) break;
                        witnesses.set(witnessIndex, (String)new Witness(this.getZeros(initialLength)));
                        witnessIndex += ((List)lockInputsMap.get(lockHash)).size();
                    }
                    transaction.witnesses = witnesses;
                    sumNeedCapacity = needCapacity.add(this.calculateTxFee(transaction, feeRate)).add(this.calculateOutputSize(changeOutput));
                    if (inputsCapacity.compareTo(sumNeedCapacity) <= 0) continue;
                    changeOutput.capacity = Numeric.prependHexPrefix((String)inputsCapacity.subtract(needCapacity).subtract(this.calculateTxFee(transaction, feeRate)).toString(16));
                    cellOutputs.set(cellOutputs.size() - 1, changeOutput);
                    transaction.outputs = cellOutputs;
                    break;
                }
                fromBlockNumber = currentToBlockNumber + 1L;
            }
        }
        if (inputsCapacity.compareTo(needCapacity.add(this.calculateTxFee(transaction, feeRate))) < 0) {
            throw new IOException("Capacity not enough!");
        }
        return lockInputsMap;
    }

    private BigInteger calculateTxFee(Transaction transaction, BigInteger feeRate) {
        int txSize = Serializer.serializeTransaction((Transaction)transaction).toBytes().length;
        return Calculator.calculateTransactionFee((BigInteger)BigInteger.valueOf(txSize), (BigInteger)feeRate);
    }

    public BigInteger getCapacityWithAddress(String address) throws IOException {
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        return this.getCapacityWithLockHash(addressParseResult.script.computeHash());
    }

    public BigInteger getCapacityWithLockHash(String lockHash) throws IOException {
        BigInteger capacity = BigInteger.ZERO;
        long toBlockNumber = this.api.getTipBlockNumber().longValue();
        long fromBlockNumber = 1L;
        while (fromBlockNumber <= toBlockNumber) {
            long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
            List cellOutputs = this.api.getCellsByLockHash(lockHash, BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
            if (cellOutputs != null && cellOutputs.size() > 0) {
                for (CellOutputWithOutPoint output : cellOutputs) {
                    capacity = capacity.add(Numeric.toBigInt((String)output.capacity));
                }
            }
            fromBlockNumber = currentToBlockNumber + 1L;
        }
        return capacity;
    }

    private BigInteger calculateOutputSize(CellOutput cellOutput) {
        return BigInteger.valueOf(Serializer.serializeCellOutput((CellOutput)cellOutput).getLength());
    }

    private String getZeros(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }
}

