/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellCollector;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectUtils;
import org.nervos.ckb.transaction.NumberUtils;
import org.nervos.ckb.transaction.Receiver;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.ScriptGroupWithPrivateKeys;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.transaction.TransactionBuilder;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.utils.Utils;

public class SendToMultiSigAddressTxExample {
    private static final String NODE_URL = "http://localhost:8114";
    private static final BigInteger UnitCKB = new BigInteger("100000000");
    private static Api api;
    private static String MultiSigAddress;
    private static String MinerPrivateKey;
    private static String MinerAddress;

    public static void main(String[] args) throws Exception {
        List<Receiver> receivers = Collections.singletonList(new Receiver(MultiSigAddress, Utils.ckbToShannon((long)20000L)));
        System.out.println("Before transfer, miner's balance: " + SendToMultiSigAddressTxExample.getBalance().divide(UnitCKB).toString(10) + " CKB");
        System.out.println("Before transfer, multi-sig address balance: " + SendToMultiSigAddressTxExample.getMultiSigBalance().divide(UnitCKB).toString(10) + " CKB");
        String hash = SendToMultiSigAddressTxExample.sendCapacity(receivers, MinerAddress);
        System.out.println("Transaction hash: " + hash);
        Thread.sleep(30000L);
        System.out.println("After transfer, multi-sig address balance: " + SendToMultiSigAddressTxExample.getMultiSigBalance().divide(UnitCKB).toString(10) + " CKB");
    }

    private static BigInteger getBalance() throws IOException {
        CellCollector cellCollector = new CellCollector(api);
        return cellCollector.getCapacityWithAddress(MinerAddress);
    }

    private static BigInteger getMultiSigBalance() throws IOException {
        CellCollector cellCollector = new CellCollector(api);
        return cellCollector.getCapacityWithAddress(MultiSigAddress);
    }

    private static String sendCapacity(List<Receiver> receivers, String changeAddress) throws IOException {
        BigInteger needCapacity = BigInteger.ZERO;
        for (Receiver receiver : receivers) {
            needCapacity = needCapacity.add(receiver.capacity);
        }
        TransactionBuilder txBuilder = new TransactionBuilder(api);
        CollectUtils txUtils = new CollectUtils(api);
        List<CellOutput> cellOutputs = txUtils.generateOutputs(receivers, changeAddress);
        txBuilder.addOutputs(cellOutputs);
        ArrayList<ScriptGroupWithPrivateKeys> scriptGroupWithPrivateKeysList = new ArrayList<ScriptGroupWithPrivateKeys>();
        BigInteger feeRate = BigInteger.valueOf(1024L);
        List<CellsWithAddress> cellsWithAddresses = txUtils.collectInputs(Collections.singletonList(MinerAddress), cellOutputs, feeRate, 130);
        int startIndex = 0;
        for (CellsWithAddress cellsWithAddress : cellsWithAddresses) {
            txBuilder.addInputs(cellsWithAddress.inputs);
            for (int i = 0; i < cellsWithAddress.inputs.size(); ++i) {
                txBuilder.addWitness(i == 0 ? new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") : "0x");
            }
            scriptGroupWithPrivateKeysList.add(new ScriptGroupWithPrivateKeys(new ScriptGroup(NumberUtils.regionToList(startIndex, cellsWithAddress.inputs.size())), Collections.singletonList(MinerPrivateKey)));
        }
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(txBuilder.buildTx());
        for (ScriptGroupWithPrivateKeys scriptGroupWithPrivateKeys : scriptGroupWithPrivateKeysList) {
            signBuilder.sign(scriptGroupWithPrivateKeys.scriptGroup, scriptGroupWithPrivateKeys.privateKeys.get(0));
        }
        return api.sendTransaction(signBuilder.buildTx());
    }

    static {
        MultiSigAddress = "ckt1qyqlqn8vsj7r0a5rvya76tey9jd2rdnca8lqh4kcuq";
        MinerPrivateKey = "e79f3207ea4980b7fed79956d5934249ceac4751a4fae01a0f7c4a96884bc4e3";
        MinerAddress = "ckt1qyqrdsefa43s6m882pcj53m4gdnj4k440axqswmu83";
        api = new Api(NODE_URL, false);
    }
}

