/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellCollector;
import org.nervos.ckb.transaction.CellCollectorWithIndexer;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.Receiver;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressParser;

public class CollectUtils {
    private Api api;
    private boolean skipDataAndType;

    public CollectUtils(Api api) {
        this.api = api;
        this.skipDataAndType = true;
    }

    public CollectUtils(Api api, boolean skipDataAndType) {
        this.api = api;
        this.skipDataAndType = skipDataAndType;
    }

    public CollectResult collectInputs(List<String> addresses, Transaction transaction, BigInteger feeRate, int initialLength) throws IOException {
        return new CellCollector(this.api, this.skipDataAndType).collectInputs(addresses, transaction, feeRate, initialLength);
    }

    public CollectResult collectInputsWithIndexer(List<String> addresses, List<CellOutput> cellOutputs, BigInteger feeRate, int initialLength) throws IOException {
        return new CellCollectorWithIndexer(this.api, this.skipDataAndType).collectInputs(addresses, cellOutputs, feeRate, initialLength);
    }

    public List<CellOutput> generateOutputs(List<Receiver> receivers, String changeAddress) {
        ArrayList<CellOutput> cellOutputs = new ArrayList<CellOutput>();
        for (Receiver receiver : receivers) {
            AddressParseResult addressParseResult = AddressParser.parse((String)receiver.address);
            cellOutputs.add(new CellOutput(Numeric.toHexStringWithPrefix((BigInteger)receiver.capacity), addressParseResult.script));
        }
        BigInteger needCapacity = BigInteger.ZERO;
        for (Receiver receiver : receivers) {
            needCapacity = needCapacity.add(receiver.capacity);
        }
        AddressParseResult addressParseResult = AddressParser.parse((String)changeAddress);
        cellOutputs.add(new CellOutput("0x0", addressParseResult.script));
        return cellOutputs;
    }
}

