/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.system.SystemContract;
import org.nervos.ckb.system.type.SystemScriptCell;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.NumberUtils;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellDep;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.cell.CellWithStatus;
import org.nervos.ckb.type.cell.LiveCell;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Calculator;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;
import org.nervos.ckb.utils.Strings;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressParser;

public class CellCollectorWithIndexer {
    private static final int PAGE_SIZE = 50;
    private Api api;
    private boolean skipDataAndType;

    public CellCollectorWithIndexer(Api api) {
        this.api = api;
        this.skipDataAndType = true;
    }

    public CellCollectorWithIndexer(Api api, boolean skipDataAndType) {
        this.api = api;
        this.skipDataAndType = skipDataAndType;
    }

    public CollectResult collectInputs(List<String> addresses, List<CellOutput> cellOutputs, BigInteger feeRate, int initialLength) throws IOException {
        ArrayList<String> lockHashes = new ArrayList<String>();
        for (String address : addresses) {
            AddressParseResult addressParseResult = AddressParser.parse((String)address);
            lockHashes.add(addressParseResult.script.computeHash());
        }
        ArrayList<String> cellOutputsData = new ArrayList<String>();
        for (int i = 0; i < cellOutputs.size() - 1; ++i) {
            BigInteger size = cellOutputs.get(i).occupiedCapacity("0x");
            if (size.compareTo(Numeric.toBigInt((String)cellOutputs.get((int)i).capacity)) > 0) {
                throw new IOException("Cell output byte size must not be bigger than capacity");
            }
            cellOutputsData.add("0x");
        }
        SystemScriptCell systemScriptCell = SystemContract.getSystemSecpCell((Api)this.api);
        cellOutputsData.add("0x");
        List<CellDep> cellDeps = Collections.singletonList(new CellDep(systemScriptCell.outPoint, "dep_group"));
        Transaction transaction = new Transaction("0", cellDeps, Collections.emptyList(), Collections.emptyList(), cellOutputs, cellOutputsData, Collections.emptyList());
        BigInteger inputsCapacity = BigInteger.ZERO;
        ArrayList<CellInput> cellInputs = new ArrayList<CellInput>();
        HashMap lockInputsMap = new HashMap();
        for (String lockHash : lockHashes) {
            lockInputsMap.put(lockHash, new ArrayList());
        }
        ArrayList<String> witnesses = new ArrayList<String>();
        CellOutput changeOutput = cellOutputs.get(cellOutputs.size() - 1);
        BigInteger needCapacity = BigInteger.ZERO;
        for (CellOutput cellOutput : cellOutputs) {
            needCapacity = needCapacity.add(Numeric.toBigInt((String)cellOutput.capacity));
        }
        for (int index = 0; index < lockHashes.size(); ++index) {
            List liveCells;
            long pageNumber = 0L;
            while (inputsCapacity.compareTo(needCapacity.add(this.calculateTxFee(transaction, feeRate))) < 0 && (liveCells = this.api.getLiveCellsByLockHash((String)lockHashes.get(index), String.valueOf(pageNumber), String.valueOf(50), false)) != null && liveCells.size() != 0) {
                for (LiveCell liveCell : liveCells) {
                    String lockHash;
                    if (this.skipDataAndType) {
                        CellWithStatus cellWithStatus = this.api.getLiveCell(new OutPoint(liveCell.createdBy.txHash, liveCell.createdBy.index), true);
                        String outputsDataContent = cellWithStatus.cell.data.content;
                        CellOutput cellOutput = cellWithStatus.cell.output;
                        if (!Strings.isEmpty((String)outputsDataContent) && !"0x".equals(outputsDataContent) || cellOutput.type != null) continue;
                    }
                    CellInput cellInput = new CellInput(new OutPoint(liveCell.createdBy.txHash, liveCell.createdBy.index), "0x0");
                    inputsCapacity = inputsCapacity.add(Numeric.toBigInt((String)liveCell.cellOutput.capacity));
                    List cellInputList = (List)lockInputsMap.get(lockHashes.get(index));
                    cellInputList.add(cellInput);
                    cellInputs.add(cellInput);
                    witnesses.add("0x");
                    transaction.inputs = cellInputs;
                    transaction.witnesses = witnesses;
                    BigInteger sumNeedCapacity = needCapacity.add(this.calculateTxFee(transaction, feeRate)).add(this.calculateOutputSize(changeOutput));
                    if (inputsCapacity.compareTo(sumNeedCapacity) <= 0) continue;
                    int witnessIndex = 0;
                    Iterator iterator = lockHashes.iterator();
                    while (iterator.hasNext() && ((List)lockInputsMap.get(lockHash = (String)iterator.next())).size() != 0) {
                        witnesses.set(witnessIndex, (String)new Witness(NumberUtils.getZeros(initialLength)));
                        witnessIndex += ((List)lockInputsMap.get(lockHash)).size();
                    }
                    transaction.witnesses = witnesses;
                    sumNeedCapacity = needCapacity.add(this.calculateTxFee(transaction, feeRate)).add(this.calculateOutputSize(changeOutput));
                    if (inputsCapacity.compareTo(sumNeedCapacity) <= 0) continue;
                    break;
                }
                ++pageNumber;
            }
        }
        if (inputsCapacity.compareTo(needCapacity.add(this.calculateTxFee(transaction, feeRate))) < 0) {
            throw new IOException("Capacity not enough!");
        }
        BigInteger changeCapacity = inputsCapacity.subtract(needCapacity.add(this.calculateTxFee(transaction, feeRate)));
        ArrayList<CellsWithAddress> cellsWithAddresses = new ArrayList<CellsWithAddress>();
        for (Map.Entry entry : lockInputsMap.entrySet()) {
            cellsWithAddresses.add(new CellsWithAddress((List)entry.getValue(), addresses.get(lockHashes.indexOf(entry.getKey()))));
        }
        return new CollectResult(cellsWithAddresses, Numeric.toHexStringWithPrefix((BigInteger)changeCapacity));
    }

    private BigInteger calculateTxFee(Transaction transaction, BigInteger feeRate) {
        int txSize = Serializer.serializeTransaction((Transaction)transaction).toBytes().length;
        return Calculator.calculateTransactionFee((BigInteger)BigInteger.valueOf(txSize), (BigInteger)feeRate);
    }

    public BigInteger getCapacityWithAddress(String address) throws IOException {
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        return this.getCapacityWithLockHash(addressParseResult.script.computeHash());
    }

    public BigInteger getCapacityWithLockHash(String lockHash) throws IOException {
        List liveCells;
        BigInteger capacity = BigInteger.ZERO;
        long pageNumber = 0L;
        while ((liveCells = this.api.getLiveCellsByLockHash(lockHash, String.valueOf(pageNumber), String.valueOf(50), false)) != null && liveCells.size() != 0) {
            for (LiveCell liveCell : liveCells) {
                if (this.skipDataAndType) {
                    CellWithStatus cellWithStatus = this.api.getLiveCell(new OutPoint(liveCell.createdBy.txHash, liveCell.createdBy.index), true);
                    String outputsDataContent = cellWithStatus.cell.data.content;
                    CellOutput cellOutput = cellWithStatus.cell.output;
                    if (!Strings.isEmpty((String)outputsDataContent) && !"0x".equals(outputsDataContent) || cellOutput.type != null) continue;
                }
                capacity = capacity.add(Numeric.toBigInt((String)liveCell.cellOutput.capacity));
            }
            ++pageNumber;
        }
        return capacity;
    }

    private BigInteger calculateOutputSize(CellOutput cellOutput) {
        return BigInteger.valueOf(Serializer.serializeCellOutput((CellOutput)cellOutput).getLength());
    }
}

