/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.NumberUtils;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.cell.CellOutputWithOutPoint;
import org.nervos.ckb.type.cell.CellWithStatus;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Calculator;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;
import org.nervos.ckb.utils.Strings;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressParser;

public class CellCollector {
    private Api api;
    private boolean skipDataAndType;

    public CellCollector(Api api, boolean skipDataAndType) {
        this.api = api;
        this.skipDataAndType = skipDataAndType;
    }

    public CellCollector(Api api) {
        this.api = api;
        this.skipDataAndType = true;
    }

    public CollectResult collectInputs(List<String> addresses, Transaction tx, BigInteger feeRate, int initialLength) throws IOException {
        ArrayList<String> lockHashes = new ArrayList<String>();
        for (String string : addresses) {
            AddressParseResult addressParseResult = AddressParser.parse((String)string);
            lockHashes.add(addressParseResult.script.computeHash());
        }
        HashMap lockInputsMap = new HashMap();
        for (String lockHash : lockHashes) {
            lockInputsMap.put(lockHash, new ArrayList());
        }
        ArrayList<CellInput> arrayList = new ArrayList<CellInput>();
        for (int i = 0; i < tx.outputs.size() - 1; ++i) {
            BigInteger size = ((CellOutput)tx.outputs.get(i)).occupiedCapacity("0x");
            if (size.compareTo(Numeric.toBigInt((String)((CellOutput)tx.outputs.get((int)i)).capacity)) <= 0) continue;
            throw new IOException("Cell output byte size must not be bigger than capacity");
        }
        Transaction transaction = new Transaction("0", tx.cellDeps, tx.headerDeps, tx.inputs, tx.outputs, tx.outputsData, Collections.emptyList());
        BigInteger inputsCapacity = BigInteger.ZERO;
        for (CellInput cellInput : tx.inputs) {
            arrayList.add(cellInput);
            CellWithStatus cellWithStatus = this.api.getLiveCell(cellInput.previousOutput, false);
            inputsCapacity = inputsCapacity.add(Numeric.toBigInt((String)cellWithStatus.cell.output.capacity));
        }
        ArrayList<String> witnesses = new ArrayList<String>();
        CellOutput changeOutput = (CellOutput)tx.outputs.get(tx.outputs.size() - 1);
        BigInteger needCapacity = BigInteger.ZERO;
        for (CellOutput cellOutput : tx.outputs) {
            needCapacity = needCapacity.add(Numeric.toBigInt((String)cellOutput.capacity));
        }
        for (String lockHash : lockHashes) {
            long toBlockNumber = this.api.getTipBlockNumber().longValue();
            long fromBlockNumber = 1L;
            while (fromBlockNumber <= toBlockNumber && inputsCapacity.compareTo(needCapacity.add(this.calculateTxFee(transaction, feeRate))) < 0) {
                long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
                List cellOutputList = this.api.getCellsByLockHash(lockHash, BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
                for (CellOutputWithOutPoint cellOutputWithOutPoint : cellOutputList) {
                    String hash;
                    if (this.skipDataAndType) {
                        CellWithStatus cellWithStatus = this.api.getLiveCell(cellOutputWithOutPoint.outPoint, true);
                        String outputsDataContent = cellWithStatus.cell.data.content;
                        CellOutput cellOutput = cellWithStatus.cell.output;
                        if (!Strings.isEmpty((String)outputsDataContent) && !"0x".equals(outputsDataContent) || cellOutput.type != null) continue;
                    }
                    CellInput cellInput = new CellInput(cellOutputWithOutPoint.outPoint, "0x0");
                    inputsCapacity = inputsCapacity.add(Numeric.toBigInt((String)cellOutputWithOutPoint.capacity));
                    List cellInputList = (List)lockInputsMap.get(lockHash);
                    cellInputList.add(cellInput);
                    arrayList.add(cellInput);
                    witnesses.add("0x");
                    transaction.inputs = arrayList;
                    transaction.witnesses = witnesses;
                    BigInteger sumNeedCapacity = needCapacity.add(this.calculateTxFee(transaction, feeRate)).add(this.calculateOutputSize(changeOutput));
                    if (inputsCapacity.compareTo(sumNeedCapacity) <= 0) continue;
                    int witnessIndex = 0;
                    Iterator iterator = lockHashes.iterator();
                    while (iterator.hasNext() && ((List)lockInputsMap.get(hash = (String)iterator.next())).size() != 0) {
                        witnesses.set(witnessIndex, (String)new Witness(NumberUtils.getZeros(initialLength)));
                        witnessIndex += ((List)lockInputsMap.get(hash)).size();
                    }
                    transaction.witnesses = witnesses;
                    sumNeedCapacity = needCapacity.add(this.calculateTxFee(transaction, feeRate)).add(this.calculateOutputSize(changeOutput));
                    if (inputsCapacity.compareTo(sumNeedCapacity) <= 0) continue;
                    break;
                }
                fromBlockNumber = currentToBlockNumber + 1L;
            }
        }
        if (inputsCapacity.compareTo(needCapacity.add(this.calculateTxFee(transaction, feeRate))) < 0) {
            throw new IOException("Capacity not enough!");
        }
        BigInteger changeCapacity = inputsCapacity.subtract(needCapacity.add(this.calculateTxFee(transaction, feeRate)));
        ArrayList<CellsWithAddress> cellsWithAddresses = new ArrayList<CellsWithAddress>();
        for (Map.Entry entry : lockInputsMap.entrySet()) {
            cellsWithAddresses.add(new CellsWithAddress((List)entry.getValue(), addresses.get(lockHashes.indexOf(entry.getKey()))));
        }
        if (tx.inputs != null && tx.inputs.size() > 0) {
            ((CellsWithAddress)cellsWithAddresses.get((int)0)).inputs.addAll(0, tx.inputs);
        }
        return new CollectResult(cellsWithAddresses, Numeric.toHexStringWithPrefix((BigInteger)changeCapacity));
    }

    private BigInteger calculateTxFee(Transaction transaction, BigInteger feeRate) {
        int txSize = Serializer.serializeTransaction((Transaction)transaction).toBytes().length;
        return Calculator.calculateTransactionFee((BigInteger)BigInteger.valueOf(txSize), (BigInteger)feeRate);
    }

    public BigInteger getCapacityWithAddress(String address) throws IOException {
        AddressParseResult addressParseResult = AddressParser.parse((String)address);
        return this.getCapacityWithLockHash(addressParseResult.script.computeHash());
    }

    public BigInteger getCapacityWithLockHash(String lockHash) throws IOException {
        BigInteger capacity = BigInteger.ZERO;
        long toBlockNumber = this.api.getTipBlockNumber().longValue();
        long fromBlockNumber = 1L;
        while (fromBlockNumber <= toBlockNumber) {
            long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
            List cellOutputs = this.api.getCellsByLockHash(lockHash, BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
            if (cellOutputs != null && cellOutputs.size() > 0) {
                for (CellOutputWithOutPoint output : cellOutputs) {
                    if (this.skipDataAndType) {
                        CellWithStatus cellWithStatus = this.api.getLiveCell(output.outPoint, true);
                        String outputsDataContent = cellWithStatus.cell.data.content;
                        CellOutput cellOutput = cellWithStatus.cell.output;
                        if (!Strings.isEmpty((String)outputsDataContent) && !"0x".equals(outputsDataContent) || cellOutput.type != null) continue;
                    }
                    capacity = capacity.add(Numeric.toBigInt((String)output.capacity));
                }
            }
            fromBlockNumber = currentToBlockNumber + 1L;
        }
        return capacity;
    }

    private BigInteger calculateOutputSize(CellOutput cellOutput) {
        return BigInteger.valueOf(Serializer.serializeCellOutput((CellOutput)cellOutput).getLength());
    }
}

