/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.TransactionInput;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.cell.CellWithStatus;
import org.nervos.ckb.type.cell.LiveCell;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Strings;
import org.nervos.ckb.utils.address.AddressParser;

public class CellIndexerIterator
implements Iterator<TransactionInput> {
    private static final int PAGE_SIZE = 50;
    private List<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
    private int addressIndex;
    private int inputIndex;
    private int pageNumber;
    private List<String> addresses;
    private Api api;
    private boolean skipDataAndType;

    CellIndexerIterator(Api api, List<String> addresses, boolean skipDataAndType) {
        this.api = api;
        this.addresses = addresses;
        this.skipDataAndType = skipDataAndType;
        this.addressIndex = 0;
        this.inputIndex = 0;
        this.pageNumber = 0;
    }

    CellIndexerIterator(Api api, List<String> addresses) {
        this(api, addresses, true);
    }

    @Override
    public boolean hasNext() {
        return this.transactionInputs.size() > 0 || this.addressIndex < this.addresses.size();
    }

    @Override
    public TransactionInput next() {
        if (this.transactionInputs.size() > 0 && this.inputIndex < this.transactionInputs.size()) {
            return this.transactionInputs.get(this.inputIndex++);
        }
        this.transactionInputs.clear();
        this.inputIndex = 0;
        do {
            String lockHash = AddressParser.parse((String)this.addresses.get((int)this.addressIndex)).script.computeHash();
            this.transactionInputs = this.fetchTransactionInputsByLockHash(lockHash);
            if (this.transactionInputs == null || this.transactionInputs.size() == 0) {
                this.pageNumber = 0;
                ++this.addressIndex;
            }
            if (this.addressIndex < this.addresses.size()) continue;
            return null;
        } while (this.transactionInputs == null || this.transactionInputs.size() == 0);
        return this.transactionInputs.get(this.inputIndex++);
    }

    private List<TransactionInput> fetchTransactionInputsByLockHash(String lockHash) {
        List liveCells = new ArrayList();
        try {
            liveCells = this.api.getLiveCellsByLockHash(lockHash, String.valueOf(this.pageNumber++), String.valueOf(50), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (LiveCell liveCell : liveCells) {
            if (this.skipDataAndType) {
                try {
                    CellWithStatus cellWithStatus = this.api.getLiveCell(new OutPoint(liveCell.createdBy.txHash, liveCell.createdBy.index), true);
                    String outputsDataContent = cellWithStatus.cell.data.content;
                    CellOutput cellOutput = cellWithStatus.cell.output;
                    if (!Strings.isEmpty((String)outputsDataContent) && !"0x".equals(outputsDataContent) || cellOutput.type != null) {
                        continue;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            CellInput cellInput = new CellInput(new OutPoint(liveCell.createdBy.txHash, liveCell.createdBy.index), "0x0");
            BigInteger capacity = Numeric.toBigInt((String)liveCell.cellOutput.capacity);
            this.transactionInputs.add(new TransactionInput(cellInput, capacity, lockHash));
        }
        if (liveCells.size() == 0) {
            this.transactionInputs.clear();
        }
        return this.transactionInputs;
    }
}

