/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellBlockIterator;
import org.nervos.ckb.transaction.CellCollector;
import org.nervos.ckb.transaction.CellIndexerIterator;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.Receiver;
import org.nervos.ckb.transaction.TransactionInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressParser;

public class CollectUtils {
    private Api api;
    private boolean skipDataAndType;

    public CollectUtils(Api api) {
        this.api = api;
        this.skipDataAndType = true;
    }

    public CollectUtils(Api api, boolean skipDataAndType) {
        this.api = api;
        this.skipDataAndType = skipDataAndType;
    }

    public CollectResult collectInputs(List<String> addresses, Transaction transaction, BigInteger feeRate, int initialLength) throws IOException {
        return new CellCollector(this.api).collectInputs(addresses, transaction, feeRate, initialLength, (Iterator)new CellBlockIterator(this.api, addresses, this.skipDataAndType));
    }

    public CollectResult collectInputsWithIndexer(List<String> addresses, Transaction transaction, BigInteger feeRate, int initialLength) throws IOException {
        return new CellCollector(this.api).collectInputs(addresses, transaction, feeRate, initialLength, (Iterator)new CellIndexerIterator(this.api, addresses, this.skipDataAndType));
    }

    public BigInteger getCapacityWithAddress(String address, boolean withIndexer) {
        TransactionInput transactionInput;
        Iterator<TransactionInput> cellIterator;
        BigInteger capacity = BigInteger.ZERO;
        Iterator<TransactionInput> iterator = cellIterator = withIndexer ? new CellIndexerIterator(this.api, Collections.singletonList(address)) : new CellBlockIterator(this.api, Collections.singletonList(address));
        while (cellIterator.hasNext() && (transactionInput = cellIterator.next()) != null) {
            capacity = capacity.add(transactionInput.capacity);
        }
        return capacity;
    }

    public BigInteger getCapacityWithAddress(String address) {
        return this.getCapacityWithAddress(address, false);
    }

    public List<CellOutput> generateOutputs(List<Receiver> receivers, String changeAddress) {
        ArrayList<CellOutput> cellOutputs = new ArrayList<CellOutput>();
        for (Receiver receiver : receivers) {
            AddressParseResult addressParseResult = AddressParser.parse((String)receiver.address);
            cellOutputs.add(new CellOutput(Numeric.toHexStringWithPrefix((BigInteger)receiver.capacity), addressParseResult.script));
        }
        BigInteger needCapacity = BigInteger.ZERO;
        for (Receiver receiver : receivers) {
            needCapacity = needCapacity.add(receiver.capacity);
        }
        AddressParseResult addressParseResult = AddressParser.parse((String)changeAddress);
        cellOutputs.add(new CellOutput("0x0", addressParseResult.script));
        return cellOutputs;
    }
}

