/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.TransactionInput;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.cell.CellOutputWithOutPoint;
import org.nervos.ckb.type.cell.CellWithStatus;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Strings;
import org.nervos.ckb.utils.address.AddressParser;

public class CellBlockIterator
implements Iterator<TransactionInput> {
    private List<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
    private long toBlockNumber;
    private long fromBlockNumber;
    private int addressIndex;
    private int inputIndex;
    private List<String> addresses;
    private Api api;
    private boolean skipDataAndType;

    CellBlockIterator(Api api, List<String> addresses, boolean skipDataAndType, long fromBlockNumber) {
        this.api = api;
        this.addresses = addresses;
        this.skipDataAndType = skipDataAndType;
        this.fromBlockNumber = fromBlockNumber;
        this.toBlockNumber = 0L;
        this.addressIndex = 0;
        this.inputIndex = 0;
        try {
            this.toBlockNumber = api.getTipBlockNumber().longValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    CellBlockIterator(Api api, List<String> addresses, boolean skipDataAndType) {
        this(api, addresses, skipDataAndType, 0L);
    }

    CellBlockIterator(Api api, List<String> addresses) {
        this(api, addresses, true);
    }

    @Override
    public boolean hasNext() {
        return this.transactionInputs.size() > 0 || this.fromBlockNumber <= this.toBlockNumber || this.addressIndex < this.addresses.size();
    }

    @Override
    public TransactionInput next() {
        if (this.transactionInputs.size() > 0 && this.inputIndex < this.transactionInputs.size()) {
            return this.transactionInputs.get(this.inputIndex++);
        }
        this.transactionInputs.clear();
        this.inputIndex = 0;
        this.transactionInputs = this.fetchTransactionInputsForAddresses();
        if (this.transactionInputs == null || this.transactionInputs.size() == 0) {
            return null;
        }
        return this.transactionInputs.get(this.inputIndex++);
    }

    private List<TransactionInput> fetchTransactionInputsForAddresses() {
        List<TransactionInput> transactionInputs;
        do {
            String lockHash;
            if ((transactionInputs = this.fetchTransactionInputsByLockHash(lockHash = AddressParser.parse((String)this.addresses.get((int)this.addressIndex)).script.computeHash())).size() == 0) {
                this.fromBlockNumber = 1L;
                ++this.addressIndex;
            }
            if (this.addressIndex < this.addresses.size()) continue;
            return null;
        } while (transactionInputs.size() == 0);
        return transactionInputs;
    }

    private List<TransactionInput> fetchTransactionInputsByLockHash(String lockHash) {
        ArrayList<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
        List cellOutputList = new ArrayList();
        do {
            long currentToBlockNumber;
            if (this.fromBlockNumber > (currentToBlockNumber = Math.min(this.fromBlockNumber + 100L, this.toBlockNumber))) {
                transactionInputs.clear();
                break;
            }
            try {
                cellOutputList = this.api.getCellsByLockHash(lockHash, BigInteger.valueOf(this.fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (CellOutputWithOutPoint cellOutputWithOutPoint : cellOutputList) {
                if (this.skipDataAndType) {
                    try {
                        CellWithStatus cellWithStatus = this.api.getLiveCell(cellOutputWithOutPoint.outPoint, true);
                        String outputsDataContent = cellWithStatus.cell.data.content;
                        CellOutput cellOutput = cellWithStatus.cell.output;
                        if (!Strings.isEmpty((String)outputsDataContent) && !"0x".equals(outputsDataContent) || cellOutput.type != null) {
                            continue;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                CellInput cellInput = new CellInput(cellOutputWithOutPoint.outPoint, "0x0");
                BigInteger capacity = Numeric.toBigInt((String)cellOutputWithOutPoint.capacity);
                transactionInputs.add(new TransactionInput(cellInput, capacity, lockHash));
            }
            if (transactionInputs.size() == 0) {
                cellOutputList.clear();
            }
            this.fromBlockNumber = currentToBlockNumber + 1L;
        } while (cellOutputList.size() == 0);
        return transactionInputs;
    }
}

