/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.CollectUtils;
import org.nervos.ckb.transaction.NumberUtils;
import org.nervos.ckb.transaction.Receiver;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.ScriptGroupWithPrivateKeys;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.transaction.TransactionBuilder;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.utils.Utils;

public class SingleKeySingleSigTxExample {
    private static final String NODE_URL = "http://localhost:8114";
    private static final BigInteger UnitCKB = new BigInteger("100000000");
    private static Api api;
    private static List<String> ReceiveAddresses;
    private static String TestPrivateKey;
    private static String TestAddress;

    public static void main(String[] args) throws Exception {
        List<Receiver> receivers = Arrays.asList(new Receiver(ReceiveAddresses.get(0), Utils.ckbToShannon((long)8000L)), new Receiver(ReceiveAddresses.get(1), Utils.ckbToShannon((long)9000L)));
        String changeAddress = "ckt1qyqvsv5240xeh85wvnau2eky8pwrhh4jr8ts8vyj37";
        System.out.println("Before transferring, sender's balance: " + SingleKeySingleSigTxExample.getBalance(TestAddress) + " CKB");
        System.out.println("Before transferring, first receiver's balance: " + SingleKeySingleSigTxExample.getBalance(ReceiveAddresses.get(0)) + " CKB");
        System.out.println("Before transferring, change address's balance: " + SingleKeySingleSigTxExample.getBalance(changeAddress) + " CKB");
        String hash = SingleKeySingleSigTxExample.sendCapacity(receivers, changeAddress);
        System.out.println("Transaction hash: " + hash);
        Thread.sleep(30000L);
        System.out.println("After transferring, sender's balance: " + SingleKeySingleSigTxExample.getBalance(TestAddress) + " CKB");
        System.out.println("After transferring, receiver's balance: " + SingleKeySingleSigTxExample.getBalance(ReceiveAddresses.get(0)) + " CKB");
        System.out.println("After transferring, change address's balance: " + SingleKeySingleSigTxExample.getBalance(changeAddress) + " CKB");
    }

    private static String getBalance(String address) {
        return new CollectUtils(api).getCapacityWithAddress(address).divide(UnitCKB).toString(10);
    }

    private static String sendCapacity(List<Receiver> receivers, String changeAddress) throws IOException {
        ArrayList<ScriptGroupWithPrivateKeys> scriptGroupWithPrivateKeysList = new ArrayList<ScriptGroupWithPrivateKeys>();
        TransactionBuilder txBuilder = new TransactionBuilder(api);
        CollectUtils txUtils = new CollectUtils(api);
        List<CellOutput> cellOutputs = txUtils.generateOutputs(receivers, changeAddress);
        txBuilder.addOutputs(cellOutputs);
        BigInteger feeRate = BigInteger.valueOf(1024L);
        CollectResult collectResult = txUtils.collectInputs(Collections.singletonList(TestAddress), txBuilder.buildTx(), feeRate, 130);
        cellOutputs.get((int)(cellOutputs.size() - 1)).capacity = collectResult.changeCapacity;
        txBuilder.setOutputs(cellOutputs);
        int startIndex = 0;
        for (CellsWithAddress cellsWithAddress : collectResult.cellsWithAddresses) {
            txBuilder.addInputs(cellsWithAddress.inputs);
            for (int i = 0; i < cellsWithAddress.inputs.size(); ++i) {
                txBuilder.addWitness(i == 0 ? new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") : "0x");
            }
            scriptGroupWithPrivateKeysList.add(new ScriptGroupWithPrivateKeys(new ScriptGroup(NumberUtils.regionToList(startIndex, cellsWithAddress.inputs.size())), Collections.singletonList(TestPrivateKey)));
        }
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(txBuilder.buildTx());
        for (ScriptGroupWithPrivateKeys scriptGroupWithPrivateKeys : scriptGroupWithPrivateKeysList) {
            signBuilder.sign(scriptGroupWithPrivateKeys.scriptGroup, scriptGroupWithPrivateKeys.privateKeys.get(0));
        }
        return api.sendTransaction(signBuilder.buildTx());
    }

    static {
        TestPrivateKey = "d00c06bfd800d27397002dca6fb0993d5ba6399b4238b2f29ee9deb97593d2bc";
        TestAddress = "ckt1qyqvsv5240xeh85wvnau2eky8pwrhh4jr8ts8vyj37";
        api = new Api(NODE_URL, false);
        ReceiveAddresses = Arrays.asList("ckt1qyqxgp7za7dajm5wzjkye52asc8fxvvqy9eqlhp82g", "ckt1qyqtnz38fht9nvmrfdeunrhdtp29n0gagkps4duhek");
    }
}

