/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.CollectUtils;
import org.nervos.ckb.transaction.NumberUtils;
import org.nervos.ckb.transaction.Receiver;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.ScriptGroupWithPrivateKeys;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.transaction.TransactionBuilder;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.utils.Utils;

public class SendToMultiSigAddressTxExample {
    private static final String NODE_URL = "http://localhost:8114";
    private static final BigInteger UnitCKB = new BigInteger("100000000");
    private static Api api;
    private static String MultiSigAddress;
    private static String TestPrivateKey;
    private static String TestAddress;

    public static void main(String[] args) throws Exception {
        List<Receiver> receivers = Collections.singletonList(new Receiver(MultiSigAddress, Utils.ckbToShannon((long)20000L)));
        String changeAddress = "ckt1qyqvsv5240xeh85wvnau2eky8pwrhh4jr8ts8vyj37";
        System.out.println("Before transferring, sender's balance: " + SendToMultiSigAddressTxExample.getBalance() + " CKB");
        System.out.println("Before transferring, multi-sig address balance: " + SendToMultiSigAddressTxExample.getMultiSigBalance() + " CKB");
        System.out.println("Before transferring, change address balance: " + SendToMultiSigAddressTxExample.getBalance() + " CKB");
        String hash = SendToMultiSigAddressTxExample.sendCapacity(receivers, changeAddress);
        System.out.println("Transaction hash: " + hash);
        Thread.sleep(30000L);
        System.out.println("After transferring, sender's address balance: " + SendToMultiSigAddressTxExample.getBalance() + " CKB");
        System.out.println("After transferring, multi-sig address balance: " + SendToMultiSigAddressTxExample.getMultiSigBalance() + " CKB");
        System.out.println("After transferring, change address balance: " + SendToMultiSigAddressTxExample.getBalance() + " CKB");
    }

    private static String getBalance() {
        return new CollectUtils(api).getCapacityWithAddress(TestAddress).divide(UnitCKB).toString(10);
    }

    private static String getMultiSigBalance() {
        return new CollectUtils(api).getCapacityWithAddress(MultiSigAddress).divide(UnitCKB).toString(10);
    }

    private static String sendCapacity(List<Receiver> receivers, String changeAddress) throws IOException {
        TransactionBuilder txBuilder = new TransactionBuilder(api);
        CollectUtils txUtils = new CollectUtils(api);
        List<CellOutput> cellOutputs = txUtils.generateOutputs(receivers, changeAddress);
        txBuilder.addOutputs(cellOutputs);
        ArrayList<ScriptGroupWithPrivateKeys> scriptGroupWithPrivateKeysList = new ArrayList<ScriptGroupWithPrivateKeys>();
        BigInteger feeRate = BigInteger.valueOf(1024L);
        CollectResult collectResult = txUtils.collectInputs(Collections.singletonList(TestAddress), txBuilder.buildTx(), feeRate, 130);
        cellOutputs.get((int)(cellOutputs.size() - 1)).capacity = collectResult.changeCapacity;
        txBuilder.setOutputs(cellOutputs);
        int startIndex = 0;
        for (CellsWithAddress cellsWithAddress : collectResult.cellsWithAddresses) {
            txBuilder.addInputs(cellsWithAddress.inputs);
            for (int i = 0; i < cellsWithAddress.inputs.size(); ++i) {
                txBuilder.addWitness(i == 0 ? new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") : "0x");
            }
            scriptGroupWithPrivateKeysList.add(new ScriptGroupWithPrivateKeys(new ScriptGroup(NumberUtils.regionToList(startIndex, cellsWithAddress.inputs.size())), Collections.singletonList(TestPrivateKey)));
        }
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(txBuilder.buildTx());
        for (ScriptGroupWithPrivateKeys scriptGroupWithPrivateKeys : scriptGroupWithPrivateKeysList) {
            signBuilder.sign(scriptGroupWithPrivateKeys.scriptGroup, scriptGroupWithPrivateKeys.privateKeys.get(0));
        }
        return api.sendTransaction(signBuilder.buildTx());
    }

    static {
        MultiSigAddress = "ckt1qyqlqn8vsj7r0a5rvya76tey9jd2rdnca8lqh4kcuq";
        TestPrivateKey = "d00c06bfd800d27397002dca6fb0993d5ba6399b4238b2f29ee9deb97593d2bc";
        TestAddress = "ckt1qyqvsv5240xeh85wvnau2eky8pwrhh4jr8ts8vyj37";
        api = new Api(NODE_URL, false);
    }
}

