/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.udt;

import io.reactivex.annotations.NonNull;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.cell.CellOutputWithOutPoint;
import org.nervos.ckb.type.cell.CellWithStatus;
import org.nervos.ckb.type.fixed.UInt128;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.udt.UDTCollectResult;
import org.nervos.ckb.utils.Calculator;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Serializer;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressParser;

public class UDTCellCollector {
    private static final BigInteger MIN_UDT_CHANGE_CAPACITY = BigInteger.valueOf(142L);
    private Api api;

    public UDTCellCollector(Api api) {
        this.api = api;
    }

    public UDTCollectResult collectInputs(List<String> addresses, Transaction tx, BigInteger feeRate, int initialLength, @NonNull String typeHash, BigInteger udtAmount) throws IOException {
        ArrayList<String> lockHashes = new ArrayList<String>();
        for (String string : addresses) {
            AddressParseResult addressParseResult = AddressParser.parse((String)string);
            lockHashes.add(addressParseResult.script.computeHash());
        }
        HashMap lockInputsMap = new HashMap();
        for (String lockHash : lockHashes) {
            lockInputsMap.put(lockHash, new ArrayList());
        }
        ArrayList<CellInput> arrayList = new ArrayList<CellInput>();
        for (int i = 0; i < tx.outputs.size() - 1; ++i) {
            BigInteger size = ((CellOutput)tx.outputs.get(i)).occupiedCapacity("0x");
            if (size.compareTo(Numeric.toBigInt((String)((CellOutput)tx.outputs.get((int)i)).capacity)) <= 0) continue;
            throw new IOException("Cell output byte size must not be bigger than capacity");
        }
        Transaction transaction = new Transaction("0", tx.cellDeps, tx.headerDeps, tx.inputs, tx.outputs, tx.outputsData, Collections.emptyList());
        BigInteger inputsCapacity = BigInteger.ZERO;
        for (CellInput cellInput : tx.inputs) {
            arrayList.add(cellInput);
            CellWithStatus cellWithStatus = this.api.getLiveCell(cellInput.previousOutput, false);
            inputsCapacity = inputsCapacity.add(Numeric.toBigInt((String)cellWithStatus.cell.output.capacity));
        }
        ArrayList<String> witnesses = new ArrayList<String>();
        CellOutput changeOutput = (CellOutput)tx.outputs.get(tx.outputs.size() - 1);
        BigInteger needCapacity = BigInteger.ZERO;
        for (CellOutput cellOutput : tx.outputs) {
            needCapacity = needCapacity.add(Numeric.toBigInt((String)cellOutput.capacity));
        }
        BigInteger inputUdtAmount = BigInteger.ZERO;
        for (String lockHash : lockHashes) {
            long toBlockNumber = this.api.getTipBlockNumber().longValue();
            long fromBlockNumber = 1L;
            while (fromBlockNumber <= toBlockNumber) {
                long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
                List cellOutputList = this.api.getCellsByLockHash(lockHash, BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
                for (CellOutputWithOutPoint cellOutputWithOutPoint : cellOutputList) {
                    String hash;
                    boolean udtAmountValid;
                    CellWithStatus cellWithStatus = this.api.getLiveCell(cellOutputWithOutPoint.outPoint, true);
                    CellOutput cellOutput = cellWithStatus.cell.output;
                    String outputsData = cellWithStatus.cell.data.content;
                    boolean udtTypeValid = cellOutput.type != null && typeHash.equals(cellOutput.type.computeHash());
                    boolean bl = udtAmountValid = outputsData != null && !"0x".equals(outputsData) && Numeric.toBigInt((String)outputsData).compareTo(BigInteger.ZERO) > 0;
                    if (!udtTypeValid || !udtAmountValid) continue;
                    inputUdtAmount = inputUdtAmount.add(new UInt128(outputsData).getValue());
                    CellInput cellInput = new CellInput(cellOutputWithOutPoint.outPoint, "0x0");
                    inputsCapacity = inputsCapacity.add(Numeric.toBigInt((String)cellOutputWithOutPoint.capacity));
                    List cellInputList = (List)lockInputsMap.get(lockHash);
                    cellInputList.add(cellInput);
                    arrayList.add(cellInput);
                    witnesses.add("0x");
                    transaction.inputs = arrayList;
                    transaction.witnesses = witnesses;
                    BigInteger sumNeedCapacity = needCapacity.add(this.calculateTxFee(transaction, feeRate)).add(this.calculateOutputSize(changeOutput));
                    if (inputsCapacity.subtract(sumNeedCapacity).compareTo(MIN_UDT_CHANGE_CAPACITY) < 0 || inputUdtAmount.compareTo(udtAmount) < 0) continue;
                    int witnessIndex = 0;
                    Iterator iterator = lockHashes.iterator();
                    while (iterator.hasNext() && ((List)lockInputsMap.get(hash = (String)iterator.next())).size() != 0) {
                        witnesses.set(witnessIndex, (String)new Witness(this.getZeros(initialLength)));
                        witnessIndex += ((List)lockInputsMap.get(hash)).size();
                    }
                    transaction.witnesses = witnesses;
                    sumNeedCapacity = needCapacity.add(this.calculateTxFee(transaction, feeRate)).add(this.calculateOutputSize(changeOutput));
                    if (inputsCapacity.subtract(sumNeedCapacity).compareTo(MIN_UDT_CHANGE_CAPACITY) < 0) continue;
                    break;
                }
                fromBlockNumber = currentToBlockNumber + 1L;
            }
        }
        if (inputsCapacity.compareTo(needCapacity.add(this.calculateTxFee(transaction, feeRate))) < 0) {
            throw new IOException("Capacity not enough!");
        }
        BigInteger changeCapacity = inputsCapacity.subtract(needCapacity.add(this.calculateTxFee(transaction, feeRate)));
        BigInteger changeUdtAmount = inputUdtAmount.subtract(udtAmount);
        ArrayList<CellsWithAddress> cellsWithAddresses = new ArrayList<CellsWithAddress>();
        for (Map.Entry entry : lockInputsMap.entrySet()) {
            cellsWithAddresses.add(new CellsWithAddress((List)entry.getValue(), addresses.get(lockHashes.indexOf(entry.getKey()))));
        }
        if (tx.inputs != null && tx.inputs.size() > 0) {
            ((CellsWithAddress)cellsWithAddresses.get((int)0)).inputs.addAll(0, tx.inputs);
        }
        return new UDTCollectResult(cellsWithAddresses, Numeric.toHexStringWithPrefix((BigInteger)changeCapacity), changeUdtAmount);
    }

    public BigInteger getUdtBalanceWithAddress(String address, @NonNull String typeHash) throws IOException {
        return this.getUdtBalanceWithLockHash(AddressParser.parse((String)address).script.computeHash(), typeHash);
    }

    public BigInteger getUdtBalanceWithLockHash(String lockHash, @NonNull String typeHash) throws IOException {
        BigInteger udtAmount = BigInteger.ZERO;
        long toBlockNumber = this.api.getTipBlockNumber().longValue();
        long fromBlockNumber = 1L;
        while (fromBlockNumber <= toBlockNumber) {
            long currentToBlockNumber = Math.min(fromBlockNumber + 100L, toBlockNumber);
            List cellOutputs = this.api.getCellsByLockHash(lockHash, BigInteger.valueOf(fromBlockNumber).toString(), BigInteger.valueOf(currentToBlockNumber).toString());
            if (cellOutputs != null && cellOutputs.size() > 0) {
                for (CellOutputWithOutPoint output : cellOutputs) {
                    CellWithStatus cellWithStatus = this.api.getLiveCell(output.outPoint, true);
                    String outputsData = cellWithStatus.cell.data.content;
                    CellOutput cellOutput = cellWithStatus.cell.output;
                    if (cellOutput.type == null || !typeHash.equals(cellOutput.type.computeHash())) continue;
                    udtAmount = udtAmount.add(new UInt128(outputsData).getValue());
                }
            }
            fromBlockNumber = currentToBlockNumber + 1L;
        }
        return udtAmount;
    }

    private BigInteger calculateTxFee(Transaction transaction, BigInteger feeRate) {
        return Calculator.calculateTransactionFee((Transaction)transaction, (BigInteger)feeRate);
    }

    private BigInteger calculateOutputSize(CellOutput cellOutput) {
        return BigInteger.valueOf(Serializer.serializeCellOutput((CellOutput)cellOutput).getLength());
    }

    private String getZeros(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }
}

