/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.service.CkbIndexerApi;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.CollectUtils;
import org.nervos.ckb.transaction.NumberUtils;
import org.nervos.ckb.transaction.Receiver;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.ScriptGroupWithPrivateKeys;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.transaction.TransactionBuilder;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Utils;

public class SingleSigWithCkbIndexerTxExample {
    private static final String NODE_URL = "http://localhost:8118";
    private static final String CKB_INDEXER_NODE_URL = "http://localhost:8116";
    private static final BigInteger UnitCKB = new BigInteger("100000000");
    private static Api api = new Api("http://localhost:8118", false);
    private static CkbIndexerApi ckbIndexerApi = new CkbIndexerApi("http://localhost:8116", false);
    private static List<String> SendPrivateKeys = Arrays.asList("08730a367dfabcadb805d69e0e613558d5160eb8bab9d6e326980c2c46a05db2", "d00c06bfd800d27397002dca6fb0993d5ba6399b4238b2f29ee9deb97593d2bc");
    private static List<String> SendAddresses = Arrays.asList("ckt1qyqxgp7za7dajm5wzjkye52asc8fxvvqy9eqlhp82g", "ckt1qyqvsv5240xeh85wvnau2eky8pwrhh4jr8ts8vyj37");
    private static List<String> ReceiveAddresses = Arrays.asList("ckt1qyqxvnycu7tdtyuejn3mmcnl4y09muxz8c3s2ewjd4", "ckt1qyqtnz38fht9nvmrfdeunrhdtp29n0gagkps4duhek");

    public static void main(String[] args) throws Exception {
        System.out.println("Wait some time for ckb-indexer running");
        List<Receiver> receivers = Arrays.asList(new Receiver(ReceiveAddresses.get(0), Utils.ckbToShannon((long)800L)), new Receiver(ReceiveAddresses.get(1), Utils.ckbToShannon((long)900L)));
        System.out.println("Before transferring, first sender's balance: " + SingleSigWithCkbIndexerTxExample.getBalance(SendAddresses.get(0)).divide(UnitCKB).toString(10) + " CKB");
        String hash = SingleSigWithCkbIndexerTxExample.sendCapacity(receivers, SendAddresses.get(0));
        System.out.println("Transaction hash: " + hash);
        Thread.sleep(30000L);
        System.out.println("After transferring, first sender's balance: " + SingleSigWithCkbIndexerTxExample.getBalance(SendAddresses.get(0)).divide(UnitCKB).toString(10) + " CKB");
    }

    private static BigInteger getBalance(String address) throws IOException {
        return new CollectUtils(ckbIndexerApi).getCapacityWithAddressByCkbIndexer(address);
    }

    private static String sendCapacity(List<Receiver> receivers, String changeAddress) throws IOException {
        ArrayList<ScriptGroupWithPrivateKeys> scriptGroupWithPrivateKeysList = new ArrayList<ScriptGroupWithPrivateKeys>();
        TransactionBuilder txBuilder = new TransactionBuilder(api);
        CollectUtils txUtils = new CollectUtils(ckbIndexerApi);
        List<CellOutput> cellOutputs = txUtils.generateOutputs(receivers, changeAddress);
        txBuilder.addOutputs(cellOutputs);
        BigInteger feeRate = BigInteger.valueOf(1024L);
        CollectResult collectResult = txUtils.collectInputsWithCkbIndexer(SendAddresses, txBuilder.buildTx(), feeRate, 130, true);
        cellOutputs.get((int)(cellOutputs.size() - 1)).capacity = collectResult.changeCapacity;
        txBuilder.setOutputs(cellOutputs);
        int startIndex = 0;
        for (Object cellsWithAddress : collectResult.cellsWithAddresses) {
            txBuilder.addInputs(((CellsWithAddress)cellsWithAddress).inputs);
            for (int i = 0; i < ((CellsWithAddress)cellsWithAddress).inputs.size(); ++i) {
                txBuilder.addWitness(i == 0 ? new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") : "0x");
            }
            if (((CellsWithAddress)cellsWithAddress).inputs.size() <= 0) continue;
            scriptGroupWithPrivateKeysList.add(new ScriptGroupWithPrivateKeys(new ScriptGroup(NumberUtils.regionToList(startIndex, ((CellsWithAddress)cellsWithAddress).inputs.size())), Collections.singletonList(SendPrivateKeys.get(SendAddresses.indexOf(((CellsWithAddress)cellsWithAddress).address)))));
            startIndex += ((CellsWithAddress)cellsWithAddress).inputs.size();
        }
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(txBuilder.buildTx());
        for (ScriptGroupWithPrivateKeys scriptGroupWithPrivateKeys : scriptGroupWithPrivateKeysList) {
            signBuilder.sign(scriptGroupWithPrivateKeys.scriptGroup, scriptGroupWithPrivateKeys.privateKeys.get(0));
        }
        Transaction tx = signBuilder.buildTx();
        return api.sendTransaction(tx);
    }
}

