/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nervos.ckb.address.AddressUtils;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellsWithAddress;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.transaction.CollectUtils;
import org.nervos.ckb.transaction.NumberUtils;
import org.nervos.ckb.transaction.Receiver;
import org.nervos.ckb.transaction.ScriptGroup;
import org.nervos.ckb.transaction.ScriptGroupWithPrivateKeys;
import org.nervos.ckb.transaction.Secp256k1SighashAllBuilder;
import org.nervos.ckb.transaction.TransactionBuilder;
import org.nervos.ckb.type.Witness;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Utils;

public class SingleSigWithIndexerTxExample {
    private static final String NODE_URL = "http://localhost:8114";
    private static final BigInteger UnitCKB = new BigInteger("100000000");
    private static Api api = new Api("http://localhost:8114", false);
    private static List<String> SendPrivateKeys = Arrays.asList("08730a367dfabcadb805d69e0e613558d5160eb8bab9d6e326980c2c46a05db2", "d00c06bfd800d27397002dca6fb0993d5ba6399b4238b2f29ee9deb97593d2bc");
    private static List<String> SendAddresses = Arrays.asList("ckt1qyqxgp7za7dajm5wzjkye52asc8fxvvqy9eqlhp82g", "ckt1qyqvsv5240xeh85wvnau2eky8pwrhh4jr8ts8vyj37");
    private static List<String> ReceiveAddresses = Arrays.asList("ckt1qyqxvnycu7tdtyuejn3mmcnl4y09muxz8c3s2ewjd4", "ckt1qyqtnz38fht9nvmrfdeunrhdtp29n0gagkps4duhek");

    public static void main(String[] args) throws Exception {
        AddressUtils utils = new AddressUtils(Network.TESTNET);
        for (int i = 0; i < SendAddresses.size() - 1; ++i) {
            String testPublicKey = ECKeyPair.publicKeyFromPrivate((String)SendPrivateKeys.get(i));
            String address = SendAddresses.get(i);
            if (address.equals(utils.generateFromPublicKey(testPublicKey))) continue;
            System.out.println("Private key and address " + address + " are not matched");
            return;
        }
        System.out.println("Call index_lock_hash rpc firstly");
        List<Receiver> receivers = Arrays.asList(new Receiver(ReceiveAddresses.get(0), Utils.ckbToShannon((long)800L)), new Receiver(ReceiveAddresses.get(1), Utils.ckbToShannon((long)900L)));
        System.out.println("Before transferring, first sender's balance: " + SingleSigWithIndexerTxExample.getBalance(SendAddresses.get(0)).divide(UnitCKB).toString(10) + " CKB");
        String hash = SingleSigWithIndexerTxExample.sendCapacity(receivers, SendAddresses.get(0));
        System.out.println("Transaction hash: " + hash);
        Thread.sleep(30000L);
        System.out.println("After transferring, first sender's balance: " + SingleSigWithIndexerTxExample.getBalance(SendAddresses.get(0)).divide(UnitCKB).toString(10) + " CKB");
    }

    private static BigInteger getBalance(String address) {
        return new CollectUtils(api).getCapacityWithAddress(address, true);
    }

    private static String sendCapacity(List<Receiver> receivers, String changeAddress) throws IOException {
        ArrayList<ScriptGroupWithPrivateKeys> scriptGroupWithPrivateKeysList = new ArrayList<ScriptGroupWithPrivateKeys>();
        TransactionBuilder txBuilder = new TransactionBuilder(api);
        CollectUtils txUtils = new CollectUtils(api);
        List<CellOutput> cellOutputs = txUtils.generateOutputs(receivers, changeAddress);
        txBuilder.addOutputs(cellOutputs);
        BigInteger feeRate = BigInteger.valueOf(1024L);
        CollectResult collectResult = txUtils.collectInputsWithIndexer(SendAddresses, txBuilder.buildTx(), feeRate, 130);
        if (Numeric.toBigInt((String)collectResult.changeCapacity).compareTo(BigInteger.ZERO) > 0) {
            cellOutputs.get((int)(cellOutputs.size() - 1)).capacity = collectResult.changeCapacity;
            txBuilder.setOutputs(cellOutputs);
        }
        int startIndex = 0;
        for (CellsWithAddress cellsWithAddress : collectResult.cellsWithAddresses) {
            txBuilder.addInputs(cellsWithAddress.inputs);
            for (int i = 0; i < cellsWithAddress.inputs.size(); ++i) {
                txBuilder.addWitness(i == 0 ? new Witness("0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000") : "0x");
            }
            if (cellsWithAddress.inputs.size() <= 0) continue;
            scriptGroupWithPrivateKeysList.add(new ScriptGroupWithPrivateKeys(new ScriptGroup(NumberUtils.regionToList(startIndex, cellsWithAddress.inputs.size())), Collections.singletonList(SendPrivateKeys.get(SendAddresses.indexOf(cellsWithAddress.address)))));
            startIndex += cellsWithAddress.inputs.size();
        }
        Secp256k1SighashAllBuilder signBuilder = new Secp256k1SighashAllBuilder(txBuilder.buildTx());
        for (ScriptGroupWithPrivateKeys scriptGroupWithPrivateKeys : scriptGroupWithPrivateKeysList) {
            signBuilder.sign(scriptGroupWithPrivateKeys.scriptGroup, scriptGroupWithPrivateKeys.privateKeys.get(0));
        }
        return api.sendTransaction(signBuilder.buildTx());
    }
}

