/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.indexer;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nervos.ckb.indexer.CkbIndexerApi;
import org.nervos.ckb.indexer.CkbIndexerCells;
import org.nervos.ckb.indexer.SearchKey;
import org.nervos.ckb.transaction.TransactionInput;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.cell.CellInput;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.Strings;
import org.nervos.ckb.utils.address.AddressParser;

public class CellCkbIndexerIterator
implements Iterator<TransactionInput> {
    private static final int PAGE_SIZE = 50;
    private List<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
    private int addressIndex;
    private int inputIndex;
    private String afterCursor;
    private final List<String> addresses;
    private final CkbIndexerApi indexerApi;
    private final boolean skipDataAndType;
    private final String order;
    private final BigInteger limit;

    CellCkbIndexerIterator(CkbIndexerApi indexerApi, List<String> addresses, boolean skipDataAndType, String order, BigInteger limit, String afterCursor) {
        this.indexerApi = indexerApi;
        this.addresses = addresses;
        this.skipDataAndType = skipDataAndType;
        this.afterCursor = afterCursor;
        this.order = order;
        this.limit = limit;
        this.addressIndex = 0;
        this.inputIndex = 0;
    }

    CellCkbIndexerIterator(CkbIndexerApi api, List<String> addresses) {
        this(api, addresses, true, "asc", BigInteger.valueOf(100L), "0x");
    }

    CellCkbIndexerIterator(CkbIndexerApi api, List<String> addresses, boolean skipDataAndType) {
        this(api, addresses, skipDataAndType, "asc", BigInteger.valueOf(100L), "0x");
    }

    @Override
    public boolean hasNext() {
        return this.transactionInputs.size() > 0 || this.addressIndex < this.addresses.size();
    }

    @Override
    public TransactionInput next() {
        if (this.transactionInputs.size() <= 0 || this.inputIndex >= this.transactionInputs.size()) {
            this.transactionInputs.clear();
            this.inputIndex = 0;
            do {
                Script script = AddressParser.parse((String)this.addresses.get((int)this.addressIndex)).script;
                this.transactionInputs = this.fetchTransactionInputsByLock(new SearchKey(script));
                if (this.transactionInputs == null || this.transactionInputs.size() == 0) {
                    this.afterCursor = "0x";
                    ++this.addressIndex;
                }
                if (this.addressIndex < this.addresses.size()) continue;
                return null;
            } while (this.transactionInputs == null || this.transactionInputs.size() == 0);
        }
        return this.transactionInputs.get(this.inputIndex++);
    }

    private List<TransactionInput> fetchTransactionInputsByLock(SearchKey searchKey) {
        List<Object> liveCells = new ArrayList();
        try {
            CkbIndexerCells response = this.indexerApi.getCells(searchKey, this.order, this.limit, this.afterCursor);
            liveCells = response.objects;
            this.afterCursor = response.lastCursor;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (CkbIndexerCells.Cell liveCell : liveCells) {
            if (this.skipDataAndType) {
                CellOutput cellOutput = liveCell.output;
                if (!Strings.isEmpty((String)liveCell.outputData) && !"0x".equals(liveCell.outputData) || cellOutput.type != null) continue;
            }
            CellInput cellInput = new CellInput(liveCell.outPoint, "0x0");
            BigInteger capacity = Numeric.toBigInt((String)liveCell.output.capacity);
            this.transactionInputs.add(new TransactionInput(cellInput, capacity, searchKey.script.computeHash()));
        }
        if (liveCells.size() == 0) {
            this.transactionInputs.clear();
        }
        return this.transactionInputs;
    }
}

