/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.indexer;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import org.nervos.ckb.indexer.CkbIndexerCells;
import org.nervos.ckb.indexer.CkbIndexerCellsCapacity;
import org.nervos.ckb.indexer.SearchKey;
import org.nervos.ckb.service.RpcService;
import org.nervos.ckb.utils.Numeric;

public class CkbIndexerApi {
    private RpcService rpcService;

    public CkbIndexerApi(String indexerUrl) {
        this(indexerUrl, false);
    }

    public CkbIndexerApi(String indexerUrl, boolean isDebug) {
        this.rpcService = new RpcService(indexerUrl, isDebug);
    }

    public CkbIndexerCells getCells(SearchKey searchKey, String order, BigInteger limit, String afterCursor) throws IOException {
        if ("0x".equals(afterCursor)) {
            return (CkbIndexerCells)this.rpcService.post("get_cells", Arrays.asList(searchKey, order, Numeric.toHexStringWithPrefix((BigInteger)limit)), CkbIndexerCells.class);
        }
        return (CkbIndexerCells)this.rpcService.post("get_cells", Arrays.asList(searchKey, order, Numeric.toHexStringWithPrefix((BigInteger)limit), afterCursor), CkbIndexerCells.class);
    }

    public CkbIndexerCellsCapacity getCellsCapacity(SearchKey searchKey) throws IOException {
        return (CkbIndexerCellsCapacity)this.rpcService.post("get_cells_capacity", Collections.singletonList(searchKey), CkbIndexerCellsCapacity.class);
    }
}

