/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.indexer;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nervos.ckb.indexer.CellCkbIndexerIterator;
import org.nervos.ckb.indexer.CkbIndexerApi;
import org.nervos.ckb.indexer.CkbIndexerCellsCapacity;
import org.nervos.ckb.indexer.Receiver;
import org.nervos.ckb.indexer.SearchKey;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.transaction.CellCollector;
import org.nervos.ckb.transaction.CollectResult;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.cell.CellOutput;
import org.nervos.ckb.type.transaction.Transaction;
import org.nervos.ckb.utils.Numeric;
import org.nervos.ckb.utils.address.AddressParseResult;
import org.nervos.ckb.utils.address.AddressParser;

public class IndexerCollector {
    private Api api;
    private CkbIndexerApi indexerApi;

    public IndexerCollector(Api api, CkbIndexerApi indexerApi) {
        this.api = api;
        this.indexerApi = indexerApi;
    }

    public CollectResult collectInputs(List<String> addresses, Transaction transaction, BigInteger feeRate, int initialLength) throws IOException {
        return new CellCollector(this.api).collectInputs(addresses, transaction, feeRate, initialLength, (Iterator)new CellCkbIndexerIterator(this.indexerApi, addresses, true));
    }

    public CollectResult collectInputs(List<String> addresses, Transaction transaction, BigInteger feeRate, int initialLength, Script type) throws IOException {
        return new CellCollector(this.api).collectInputs(addresses, transaction, feeRate, initialLength, (Iterator)new CellCkbIndexerIterator(this.indexerApi, addresses, type));
    }

    public BigInteger getCapacity(String address) throws IOException {
        AddressParseResult rs = AddressParser.parse((String)address);
        CkbIndexerCellsCapacity capacityInfo = this.indexerApi.getCellsCapacity(new SearchKey(rs.script));
        return Numeric.toBigInt((String)capacityInfo.capacity);
    }

    public List<CellOutput> generateOutputs(List<Receiver> receivers, String changeAddress) {
        ArrayList<CellOutput> cellOutputs = new ArrayList<CellOutput>();
        for (Receiver receiver : receivers) {
            AddressParseResult addressParseResult = AddressParser.parse((String)receiver.address);
            cellOutputs.add(new CellOutput(Numeric.toHexStringWithPrefix((BigInteger)receiver.capacity), addressParseResult.script));
        }
        if (changeAddress != null && !changeAddress.trim().isEmpty()) {
            AddressParseResult addressParseResult = AddressParser.parse((String)changeAddress);
            cellOutputs.add(new CellOutput("0x0", addressParseResult.script));
        }
        return cellOutputs;
    }
}

