/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.example;

import java.io.IOException;
import java.util.Iterator;
import org.nervos.ckb.Network;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.sign.TransactionSigner;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.ckb.transaction.SudtTransactionBuilder;
import org.nervos.ckb.utils.Numeric;
import org.nervos.indexer.InputIterator;

public class IssueSudtExample {
    public static void main(String[] args) throws IOException {
        Network network = Network.TESTNET;
        String sender = "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqdamwzrffgc54ef48493nfd2sd0h4cjnxg4850up";
        InputIterator iterator = new InputIterator(sender);
        TransactionWithScriptGroups txWithGroups = new SudtTransactionBuilder((Iterator)iterator, network, SudtTransactionBuilder.TransactionType.ISSUE, sender).addSudtOutput(sender, 10L).setFeeRate(1000L).setChangeOutput(sender).build();
        TransactionSigner.getInstance((Network)network).signTransaction(txWithGroups, new String[]{"0x0c982052ffd4af5f3bbf232301dcddf468009161fc48ba1426e3ce0929fb59f8"});
        Api api = new Api("https://testnet.ckb.dev", false);
        byte[] txHash = api.sendTransaction(txWithGroups.getTxView());
        System.out.println("Transaction hash: " + Numeric.toHexString((byte[])txHash));
    }
}

