/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.example;

import java.io.IOException;
import java.util.Iterator;
import org.nervos.ckb.Network;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.sign.TransactionSigner;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.ckb.transaction.CkbTransactionBuilder;
import org.nervos.ckb.utils.Numeric;
import org.nervos.indexer.InputIterator;

public class SendCkbExample {
    public static void main(String[] args) throws IOException {
        String sender = "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq2qf8keemy2p5uu0g0gn8cd4ju23s5269qk8rg4r";
        InputIterator iterator = new InputIterator(sender);
        TransactionWithScriptGroups txWithGroups = new CkbTransactionBuilder((Iterator)iterator, Network.TESTNET).addOutput("ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq2qf8keemy2p5uu0g0gn8cd4ju23s5269qk8rg4r", 50100000000L).setFeeRate(1000L).setChangeOutput(sender).build();
        TransactionSigner.getInstance((Network)Network.TESTNET).signTransaction(txWithGroups, new String[]{"0x6c9ed03816e3111e49384b8d180174ad08e29feb1393ea1b51cef1c505d4e36a"});
        Api api = new Api("https://testnet.ckb.dev", false);
        byte[] txHash = api.sendTransaction(txWithGroups.getTxView());
        System.out.println("Transaction hash: " + Numeric.toHexString((byte[])txHash));
    }
}

