/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.example;

import java.io.IOException;
import java.util.Iterator;
import org.nervos.ckb.Network;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.sign.TransactionSigner;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.ckb.transaction.DaoTransactionBuilder;
import org.nervos.ckb.transaction.InputIterator;
import org.nervos.ckb.transaction.TransactionBuilderConfiguration;
import org.nervos.ckb.transaction.handler.DaoScriptHandler;
import org.nervos.ckb.type.OutPoint;
import org.nervos.ckb.utils.Numeric;

public class DaoWithdrawExample {
    public static void main(String[] args) throws IOException {
        Network network = Network.TESTNET;
        Api api = new Api("https://testnet.ckb.dev", false);
        OutPoint depositOutPoint = new OutPoint("0xc4662aa4a0c9087aa299121fef06dcc2dbf30271441a85fdf9d62fb312b259e6", 0);
        String sender = "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq2qf8keemy2p5uu0g0gn8cd4ju23s5269qk8rg4r";
        TransactionBuilderConfiguration configuration = new TransactionBuilderConfiguration(network);
        InputIterator iterator = new InputIterator(sender);
        TransactionWithScriptGroups txWithGroups = new DaoTransactionBuilder(configuration, (Iterator)iterator, depositOutPoint, api).addWithdrawOutput(sender).setChangeOutput(sender).build(new Object[]{new DaoScriptHandler.WithdrawInfo(api, depositOutPoint)});
        TransactionSigner.getInstance((Network)network).signTransaction(txWithGroups, new String[]{"0x6c9ed03816e3111e49384b8d180174ad08e29feb1393ea1b51cef1c505d4e36a"});
        byte[] txHash = api.sendTransaction(txWithGroups.getTxView());
        System.out.println("Transaction hash: " + Numeric.toHexString((byte[])txHash));
    }
}

