/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.example;

import java.io.IOException;
import java.util.Iterator;
import org.nervos.ckb.Network;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.sign.TransactionSigner;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.ckb.transaction.AbstractInputIterator;
import org.nervos.ckb.transaction.CkbTransactionBuilder;
import org.nervos.ckb.transaction.InputIterator;
import org.nervos.ckb.transaction.OffChainInputCollector;
import org.nervos.ckb.transaction.OffChainInputIterator;
import org.nervos.ckb.transaction.TransactionBuilderConfiguration;
import org.nervos.ckb.utils.Numeric;

public class SendChainedTransactionExample {
    public static void main(String[] args) throws IOException {
        Network network = Network.TESTNET;
        String address1 = "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsq2qf8keemy2p5uu0g0gn8cd4ju23s5269qk8rg4r";
        String address2 = "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqdamwzrffgc54ef48493nfd2sd0h4cjnxg4850up";
        String address3 = "ckt1qrejnmlar3r452tcg57gvq8patctcgy8acync0hxfnyka35ywafvkqgxhjvp3k9pf88upngryvuxc346q7fq5qmlqqlrhr0p";
        OffChainInputCollector offChainInputCollector = OffChainInputCollector.getInstance();
        TransactionBuilderConfiguration configuration = new TransactionBuilderConfiguration(network);
        OffChainInputIterator iterator1 = new OffChainInputIterator((AbstractInputIterator)new InputIterator(address1), offChainInputCollector, true);
        TransactionWithScriptGroups txWithGroups = new CkbTransactionBuilder(configuration, (Iterator)iterator1).addOutput(address2, 50100000000L).setChangeOutput(address1).build();
        TransactionSigner.getInstance((Network)network).signTransaction(txWithGroups, new String[]{"0x6c9ed03816e3111e49384b8d180174ad08e29feb1393ea1b51cef1c505d4e36a"});
        Api api = new Api("https://testnet.ckb.dev", false);
        byte[] txHash = api.sendTransaction(txWithGroups.getTxView());
        offChainInputCollector.applyOffChainTransaction(api.getTipBlockNumber(), txWithGroups.getTxView());
        System.out.println("Transaction hash: " + Numeric.toHexString((byte[])txHash));
        OffChainInputIterator iterator2 = new OffChainInputIterator((AbstractInputIterator)new InputIterator(address2), offChainInputCollector, true);
        txWithGroups = new CkbTransactionBuilder(configuration, (Iterator)iterator2).addOutput(address3, 100000000000L).setChangeOutput(address2).build();
        TransactionSigner.getInstance((Network)network).signTransaction(txWithGroups, new String[]{"0x0c982052ffd4af5f3bbf232301dcddf468009161fc48ba1426e3ce0929fb59f8"});
        txHash = api.sendTransaction(txWithGroups.getTxView());
        offChainInputCollector.applyOffChainTransaction(api.getTipBlockNumber(), txWithGroups.getTxView());
        System.out.println("Transaction hash: " + Numeric.toHexString((byte[])txHash));
    }
}

