/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.example;

import java.io.IOException;
import java.util.Iterator;
import org.nervos.ckb.CkbRpcApi;
import org.nervos.ckb.Network;
import org.nervos.ckb.service.Api;
import org.nervos.ckb.sign.TransactionSigner;
import org.nervos.ckb.sign.TransactionWithScriptGroups;
import org.nervos.ckb.transaction.AbstractInputIterator;
import org.nervos.ckb.transaction.InputIterator;
import org.nervos.ckb.transaction.SudtTransactionBuilder;
import org.nervos.ckb.transaction.TransactionBuilderConfiguration;
import org.nervos.ckb.utils.Numeric;

public class SendSudtExample {
    public static void main(String[] args) throws IOException {
        Network network = Network.TESTNET;
        Api api = new Api("https://testnet.ckb.dev", false);
        String sender = "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqdamwzrffgc54ef48493nfd2sd0h4cjnxg4850up";
        byte[] sudtArgs = Numeric.hexStringToByteArray((String)"0x9d2dab815b9158b2344827749d769fd66e2d3ebdfca32e5628ba0454651851f5");
        String receiver = "ckt1qzda0cr08m85hc8jlnfp3zer7xulejywt49kt2rr0vthywaa50xwsqd0pdquvfuq077aemn447shf4d8u5f4a0glzz2g4";
        TransactionBuilderConfiguration configuration = new TransactionBuilderConfiguration(network);
        AbstractInputIterator iterator = new InputIterator((CkbRpcApi)api).addSudtSearchKey(sender, sudtArgs);
        TransactionWithScriptGroups txWithGroups = new SudtTransactionBuilder(configuration, (Iterator)iterator, SudtTransactionBuilder.TransactionType.TRANSFER, sudtArgs).addSudtOutput(receiver, 1L).setChangeOutput(sender).build();
        TransactionSigner.getInstance((Network)network).signTransaction(txWithGroups, new String[]{"0x0c982052ffd4af5f3bbf232301dcddf468009161fc48ba1426e3ce0929fb59f8"});
        byte[] txHash = api.sendTransaction(txWithGroups.getTxView());
        System.out.println("Transaction hash: " + Numeric.toHexString((byte[])txHash));
    }
}

