/*
 * Decompiled with CFR 0.152.
 */
package com.nervos.lightclient;

import com.nervos.lightclient.DefaultLightClientApi;
import com.nervos.lightclient.LightClientApi;
import com.nervos.lightclient.type.FetchedHeader;
import com.nervos.lightclient.type.FetchedTransaction;
import com.nervos.lightclient.type.ScriptDetail;
import com.nervos.lightclient.type.TransactionWithHeader;
import com.nervos.lightclient.type.TxsWithCell;
import com.nervos.lightclient.type.TxsWithCells;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;
import org.nervos.ckb.type.Block;
import org.nervos.ckb.type.Header;
import org.nervos.ckb.type.Script;
import org.nervos.ckb.type.ScriptType;
import org.nervos.ckb.utils.Numeric;
import org.nervos.indexer.model.Order;
import org.nervos.indexer.model.SearchKeyBuilder;
import org.nervos.indexer.model.resp.CellCapacityResponse;
import org.nervos.indexer.model.resp.CellsResponse;

@DisabledIfEnvironmentVariable(named="CI", matches="true")
class DefaultLightClientApiTest {
    public LightClientApi api = new DefaultLightClientApi("http://localhost:9000");
    public Script script = new Script(Numeric.hexStringToByteArray((String)"0x9bd7e06f3ecf4be0f2fcd2188b23f1b9fcc88e5d4b65a8637b17723bbda3cce8"), Numeric.hexStringToByteArray((String)"0x4049ed9cec8a0d39c7a1e899f0dacb8a8c28ad14"), Script.HashType.TYPE);

    DefaultLightClientApiTest() {
    }

    @Test
    void setScripts() throws IOException {
        ScriptDetail scriptDetail = new ScriptDetail();
        scriptDetail.script = this.script;
        scriptDetail.scriptType = ScriptType.LOCK;
        scriptDetail.blockNumber = 7033100L;
        ArrayList<ScriptDetail> scriptDetails = new ArrayList<ScriptDetail>();
        scriptDetails.add(scriptDetail);
        this.api.setScripts(scriptDetails);
    }

    @Test
    void getScripts() throws IOException {
        List scriptDetails = this.api.getScripts();
        Assertions.assertTrue((scriptDetails.size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)scriptDetails.stream().anyMatch(scriptDetail -> scriptDetail.script != null));
        Assertions.assertTrue((boolean)scriptDetails.stream().anyMatch(scriptDetail -> scriptDetail.blockNumber > 0L));
        Assertions.assertTrue((boolean)scriptDetails.stream().anyMatch(scriptDetail -> scriptDetail.scriptType != null));
    }

    @Test
    void getTipHeader() throws IOException {
        Header header = this.api.getTipHeader();
        Assertions.assertNotNull((Object)header);
    }

    @Test
    void getGenesisBlock() throws IOException {
        Block block = this.api.getGenesisBlock();
        Assertions.assertNotNull((Object)block);
    }

    @Test
    void getHeader() throws IOException {
        Header header = this.api.getHeader(Numeric.hexStringToByteArray((String)"0xc78c65185c14e1b02d6457a06b4678bab7e15f194f49a840319b57c67d20053c"));
        Assertions.assertNotNull((Object)header);
    }

    @Test
    void getTransaction() throws IOException {
        TransactionWithHeader tx = this.api.getTransaction(Numeric.hexStringToByteArray((String)"0x151d4d450c9e3bccf4b47d1ba6942d4e9c8c0eeeb7b9f708df827c164f035aa8"));
        Assertions.assertNotNull((Object)tx.header);
        Assertions.assertNotNull((Object)tx.transaction);
    }

    @Test
    void fetchHeader() throws IOException {
        FetchedHeader header = this.api.fetchHeader(Numeric.hexStringToByteArray((String)"0xcb5eae958e3ea24b0486a393133aa33d51224ffaab3c4819350095b3446e4f70"));
        Assertions.assertNotNull((Object)header.status);
        Assertions.assertNotNull((Object)header.data);
    }

    @Test
    void fetchTransaction() throws IOException {
        FetchedTransaction tx = this.api.fetchTransaction(Numeric.hexStringToByteArray((String)"0x716e211698d3d9499aae7903867c744b67b539beeceddad330e73d1b6b617aef"));
        Assertions.assertNotNull((Object)tx.status);
        Assertions.assertNotNull((Object)tx.data);
    }

    @Test
    void getCells() throws IOException {
        SearchKeyBuilder key = new SearchKeyBuilder();
        key.script(this.script);
        key.scriptType(ScriptType.LOCK);
        CellsResponse cells = this.api.getCells(key.build(), Order.ASC, 10, null);
        Assertions.assertTrue((cells.objects.size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)cells.objects.stream().anyMatch(obj -> obj.blockNumber != 0));
        Assertions.assertTrue((boolean)cells.objects.stream().anyMatch(obj -> obj.txIndex != 0));
        Assertions.assertTrue((boolean)cells.objects.stream().anyMatch(obj -> obj.outPoint != null));
        Assertions.assertTrue((boolean)cells.objects.stream().anyMatch(obj -> obj.output != null));
    }

    @Test
    void getTransactions() throws IOException {
        SearchKeyBuilder key = new SearchKeyBuilder();
        key.script(this.script);
        key.scriptType(ScriptType.LOCK);
        TxsWithCell txs = this.api.getTransactions(key.build(), Order.ASC, 10, null);
        Assertions.assertTrue((txs.objects.size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.transaction != null));
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.blockNumber != 0));
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.ioIndex != 0));
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.ioType != null));
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.txIndex != 0));
    }

    @Test
    void getTransactionsGrouped() throws IOException {
        SearchKeyBuilder key = new SearchKeyBuilder();
        key.script(this.script);
        key.scriptType(ScriptType.LOCK);
        TxsWithCells txs = this.api.getTransactionsGrouped(key.build(), Order.ASC, 10, null);
        Assertions.assertTrue((txs.objects.size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.blockNumber != 0));
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.cells.size() > 0));
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.cells.get(0) != null));
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.cells.size() >= 2 && ((TxsWithCells.Cell)obj.cells.get((int)1)).ioIndex != 0));
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.txIndex != 0));
        Assertions.assertTrue((boolean)txs.objects.stream().anyMatch(obj -> obj.transaction != null));
    }

    @Test
    void getCellsCapacity() throws IOException {
        SearchKeyBuilder key = new SearchKeyBuilder();
        key.script(this.script);
        key.scriptType(ScriptType.LOCK);
        CellCapacityResponse capacity = this.api.getCellsCapacity(key.build());
        Assertions.assertNotEquals((long)0L, (long)capacity.capacity);
        Assertions.assertNotEquals((long)0L, (long)capacity.blockNumber);
        Assertions.assertNotNull((Object)capacity.blockHash);
    }
}

