/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.utils;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import org.nervos.ckb.exceptions.AddressFormatException;

public class Bech32m {
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final int BECH32M_CONST = 734539939;
    private static final int[] GENERATOR = new int[]{996825010, 642813549, 513874426, 1027748829, 705979059};
    private static final byte[] CHARSET_REV = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15, -1, 10, 17, 21, 20, 26, 30, 7, 5, -1, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1};

    private static int polymod(byte[] values) {
        int chk = 1;
        for (byte v_i : values) {
            int top = chk >> 25;
            chk = (chk & 0x1FFFFFF) << 5 ^ v_i;
            for (int i = 0; i < 6; ++i) {
                if ((top >> i & 1) != 0) {
                    chk ^= GENERATOR[i];
                    continue;
                }
                chk ^= 0;
            }
        }
        return chk;
    }

    private static byte[] expandHrp(String hrp) {
        int hrpLength = hrp.length() * 2 + 1;
        int index = 0;
        byte[] ret = new byte[hrpLength];
        for (char ch : hrp.toCharArray()) {
            ret[index] = (byte)(Bech32m.ord(ch) >> 5);
            ++index;
        }
        ret[index] = 0;
        ++index;
        for (char ch : hrp.toCharArray()) {
            ret[index] = (byte)(Bech32m.ord(ch) & 0x1F);
            ++index;
        }
        return ret;
    }

    private static int ord(String s) {
        return s.length() > 0 ? s.getBytes(StandardCharsets.UTF_8)[0] & 0xFF : 0;
    }

    private static int ord(char c) {
        return c < 128 ? c : Bech32m.ord(Character.toString((char)c));
    }

    public static boolean verifyChecksum(String hrp, byte[] values) {
        byte[] hrpExpanded = Bech32m.expandHrp(hrp);
        byte[] combined = new byte[hrpExpanded.length + values.length];
        System.arraycopy(hrpExpanded, 0, combined, 0, hrpExpanded.length);
        System.arraycopy(values, 0, combined, hrpExpanded.length, values.length);
        return Bech32m.polymod(combined) == 734539939;
    }

    private static byte[] createChecksum(String hrp, byte[] values) {
        byte[] hrpExpanded = Bech32m.expandHrp(hrp);
        byte[] enc = new byte[hrpExpanded.length + values.length + 6];
        System.arraycopy(hrpExpanded, 0, enc, 0, hrpExpanded.length);
        System.arraycopy(values, 0, enc, hrpExpanded.length, values.length);
        int polymod = Bech32m.polymod(enc) ^ 0x2BC830A3;
        byte[] ret = new byte[6];
        for (int i = 0; i < 6; ++i) {
            ret[i] = (byte)(polymod >> 5 * (5 - i) & 0x1F);
        }
        return ret;
    }

    public static String encode(Bech32Data bech32) {
        return Bech32m.encode(bech32.hrp, bech32.data);
    }

    public static String encode(String hrp, byte[] values) {
        if (hrp.length() < 1) {
            throw new AddressFormatException.InvalidDataLength("Human-readable part is too short: " + hrp.length());
        }
        if (hrp.length() > 83) {
            throw new AddressFormatException.InvalidDataLength("Human-readable part is too long: " + hrp.length());
        }
        hrp = hrp.toLowerCase(Locale.ROOT);
        byte[] checksum = Bech32m.createChecksum(hrp, values);
        byte[] combined = new byte[values.length + checksum.length];
        System.arraycopy(values, 0, combined, 0, values.length);
        System.arraycopy(checksum, 0, combined, values.length, checksum.length);
        StringBuilder sb = new StringBuilder(hrp.length() + 1 + combined.length);
        sb.append(hrp);
        sb.append('1');
        for (byte b : combined) {
            sb.append(CHARSET.charAt(b));
        }
        return sb.toString();
    }

    public static Bech32Data decode(String str) throws AddressFormatException {
        boolean lower = false;
        boolean upper = false;
        if (str.length() < 8) {
            throw new AddressFormatException.InvalidDataLength("Input too short: " + str.length());
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < '!' || c > '~') {
                throw new AddressFormatException.InvalidCharacter(c, i);
            }
            if (c >= 'a' && c <= 'z') {
                if (upper) {
                    throw new AddressFormatException.InvalidCharacter(c, i);
                }
                lower = true;
            }
            if (c < 'A' || c > 'Z') continue;
            if (lower) {
                throw new AddressFormatException.InvalidCharacter(c, i);
            }
            upper = true;
        }
        int pos = str.lastIndexOf(49);
        if (pos < 1) {
            throw new AddressFormatException.InvalidPrefix("Missing human-readable part");
        }
        int dataPartLength = str.length() - 1 - pos;
        if (dataPartLength < 6) {
            throw new AddressFormatException.InvalidDataLength("Data part too short: " + dataPartLength);
        }
        byte[] values = new byte[dataPartLength];
        for (int i = 0; i < dataPartLength; ++i) {
            char c = str.charAt(i + pos + 1);
            if (CHARSET_REV[c] == -1) {
                throw new AddressFormatException.InvalidCharacter(c, i + pos + 1);
            }
            values[i] = CHARSET_REV[c];
        }
        String hrp = str.substring(0, pos).toLowerCase(Locale.ROOT);
        if (!Bech32m.verifyChecksum(hrp, values)) {
            throw new AddressFormatException.InvalidChecksum();
        }
        return new Bech32Data(hrp, Arrays.copyOfRange(values, 0, values.length - 6));
    }

    public static class Bech32Data {
        public final String hrp;
        public final byte[] data;

        public Bech32Data(String hrp, byte[] data) {
            this.hrp = hrp;
            this.data = data;
        }
    }
}

