/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.crypto;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.nervos.ckb.utils.Numeric;

public class Hash {
    protected static final byte[] CKB_HASH_PERSONALIZATION = "ckb-default-hash".getBytes(StandardCharsets.UTF_8);

    private Hash() {
    }

    public static String blake2b(String hexInput) {
        byte[] bytes = Numeric.hexStringToByteArray(hexInput);
        byte[] result = Hash.blake2b(bytes);
        return Numeric.toHexString(result);
    }

    public static byte[] blake2b(byte[] input, int offset, int length) {
        Blake2bDigest blake2b = new Blake2bDigest(null, 32, null, CKB_HASH_PERSONALIZATION);
        blake2b.update(input, offset, length);
        byte[] out = new byte[32];
        blake2b.doFinal(out, 0);
        return out;
    }

    public static byte[] blake2b(byte[] input) {
        return Hash.blake2b(input, 0, input.length);
    }

    public static String blake2bString(String utf8String) {
        return Numeric.toHexString(Hash.blake2b(utf8String.getBytes(StandardCharsets.UTF_8)));
    }
}

