/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.crypto.secp256k1;

import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Arrays;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.nervos.ckb.crypto.Hash;
import org.nervos.ckb.crypto.secp256k1.ECDSASignature;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.utils.Assertions;
import org.nervos.ckb.utils.Numeric;

public class Sign {
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    static final BigInteger HALF_CURVE_ORDER = CURVE_PARAMS.getN().shiftRight(1);

    public static SignatureData signMessage(byte[] message, ECKeyPair keyPair) {
        return Sign.signMessage(message, keyPair, false);
    }

    public static SignatureData signMessage(byte[] message, ECKeyPair keyPair, boolean isHash) {
        BigInteger publicKey = keyPair.getPublicKey();
        byte[] messageHash = isHash ? Hash.blake2b(message) : message;
        ECDSASignature sig = Sign.sign(keyPair, messageHash);
        int recId = -1;
        for (int i = 0; i < 4; ++i) {
            BigInteger k = Sign.recoverFromSignature(i, sig, messageHash);
            if (k == null || !k.equals(publicKey)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        int headerByte = recId;
        byte v = (byte)headerByte;
        byte[] r = Numeric.toBytesPadded(sig.r, 32);
        byte[] s = Numeric.toBytesPadded(sig.s, 32);
        return new SignatureData(v, r, s);
    }

    private static BigInteger recoverFromSignature(int recId, ECDSASignature sig, byte[] message) {
        Assertions.verifyPrecondition(recId >= 0, "recId must be positive");
        Assertions.verifyPrecondition(sig.r.signum() >= 0, "r must be positive");
        Assertions.verifyPrecondition(sig.s.signum() >= 0, "s must be positive");
        Assertions.verifyPrecondition(message != null, "message cannot be null");
        BigInteger n = CURVE.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = sig.r.add(i.multiply(n));
        BigInteger prime = SecP256K1Curve.q;
        if (x.compareTo(prime) >= 0) {
            return null;
        }
        ECPoint R = Sign.decompressKey(x, (recId & 1) == 1);
        if (!R.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, message);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = sig.r.modInverse(n);
        BigInteger srInv = rInv.multiply(sig.s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)CURVE.getG(), (BigInteger)eInvrInv, (ECPoint)R, (BigInteger)srInv);
        byte[] qBytes = q.getEncoded(false);
        return new BigInteger(1, Arrays.copyOfRange(qBytes, 1, qBytes.length));
    }

    private static ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return CURVE.getCurve().decodePoint(compEnc);
    }

    public static BigInteger signedMessageToKey(byte[] message, SignatureData signatureData) throws SignatureException {
        byte[] messageHash;
        byte[] r = signatureData.getR();
        byte[] s = signatureData.getS();
        Assertions.verifyPrecondition(r != null && r.length == 32, "r must be 32 bytes");
        Assertions.verifyPrecondition(s != null && s.length == 32, "s must be 32 bytes");
        int header = signatureData.getV() & 0xFF;
        if (header > 7) {
            throw new SignatureException("Header byte out of range: " + header);
        }
        int recId = header;
        ECDSASignature sig = new ECDSASignature(new BigInteger(1, signatureData.getR()), new BigInteger(1, signatureData.getS()));
        BigInteger key = Sign.recoverFromSignature(recId, sig, messageHash = Hash.blake2b(message));
        if (key == null) {
            throw new SignatureException("Could not recover public key from signature");
        }
        return key;
    }

    private static ECDSASignature sign(ECKeyPair ecKeyPair, byte[] transactionHash) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(ecKeyPair.getPrivateKey(), CURVE);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(transactionHash);
        return new ECDSASignature(components[0], components[1]).toCanonicalised();
    }

    public static class SignatureData {
        private final byte v;
        private final byte[] r;
        private final byte[] s;

        public SignatureData(byte v, byte[] r, byte[] s) {
            this.v = v;
            this.r = r;
            this.s = s;
        }

        public byte getV() {
            return this.v;
        }

        public byte[] getR() {
            return this.r;
        }

        public byte[] getS() {
            return this.s;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SignatureData that = (SignatureData)o;
            if (this.v != that.v) {
                return false;
            }
            if (!Arrays.equals(this.r, that.r)) {
                return false;
            }
            return Arrays.equals(this.s, that.s);
        }

        public int hashCode() {
            int result = this.v;
            result = 31 * result + Arrays.hashCode(this.r);
            result = 31 * result + Arrays.hashCode(this.s);
            return result;
        }

        public byte[] getSignature() {
            byte[] sig = new byte[65];
            System.arraycopy(this.r, 0, sig, 0, 32);
            System.arraycopy(this.s, 0, sig, 32, 32);
            sig[64] = this.v;
            return sig;
        }

        public byte[] getDerSignature() {
            int rLen = (this.r[0] & 0xFF) > 127 ? this.r.length + 1 : this.r.length;
            int sLen = (this.s[0] & 0xFF) > 127 ? this.s.length + 1 : this.s.length;
            int len = 6 + rLen + sLen;
            byte[] sig = new byte[len];
            sig[0] = 48;
            sig[1] = (byte)(len - 2);
            sig[2] = 2;
            sig[3] = (byte)rLen;
            if ((this.r[0] & 0xFF) > 127) {
                sig[4] = 0;
                System.arraycopy(this.r, 0, sig, 5, rLen - 1);
            } else {
                System.arraycopy(this.r, 0, sig, 4, rLen);
            }
            sig[4 + rLen] = 2;
            sig[4 + rLen + 1] = (byte)sLen;
            if ((this.s[0] & 0xFF) > 127) {
                sig[4 + rLen + 2] = 0;
                System.arraycopy(this.s, 0, sig, 4 + rLen + 3, sLen - 1);
            } else {
                System.arraycopy(this.s, 0, sig, 4 + rLen + 2, sLen);
            }
            return sig;
        }
    }
}

