package org.nervos.ckb.utils;

import java.util.Arrays;

/** Byte array utility functions. */
public class Bytes {

  private Bytes() {}

  public static byte[] trimLeadingBytes(byte[] bytes, byte b) {
    int offset = 0;
    for (; offset < bytes.length - 1; offset++) {
      if (bytes[offset] != b) {
        break;
      }
    }
    return Arrays.copyOfRange(bytes, offset, bytes.length);
  }

  public static byte[] trimLeadingZeroes(byte[] bytes) {
    return trimLeadingBytes(bytes, (byte) 0);
  }
}
