/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.address;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nervos.ckb.address.AddressUtils;
import org.nervos.ckb.address.CodeHashType;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.crypto.Hash;
import org.nervos.ckb.crypto.secp256k1.ECKeyPair;
import org.nervos.ckb.exceptions.AddressFormatException;

public class AddressTest {
    @Test
    public void testPublicKeyHash() {
        String hash = Hash.blake160((String)"0x024a501efd328e062c8675f2365970728c859c592beeefd6be8ead3d901330bc01");
        Assertions.assertEquals((Object)"36c329ed630d6ce750712a477543672adab57f4c", (Object)hash);
    }

    @Test
    public void testAddressAscii() {
        String bin = "P2PH";
        AddressUtils utils = new AddressUtils(Network.TESTNET);
        String data = utils.strToAscii(bin);
        Assertions.assertEquals((Object)"50325048", (Object)data);
    }

    @Test
    public void testArgToAddressTestnet() throws AddressFormatException {
        String expected = "ckt1qyqz6824th6pekd6858nru9p4j3u783fttl4k3r0cp2lt7uxhx00fxcxpzeq8";
        String args = "0x2d1d555df41cd9ba3d0f31f0a1aca3cf1e295aff5b446fc055f5fb86b99ef49b";
        AddressUtils utils = new AddressUtils(Network.TESTNET);
        String actual = utils.generate(args);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPublicKeyHashToAddressTestnet() {
        AddressUtils utils = new AddressUtils(Network.TESTNET);
        Assertions.assertEquals((Object)"ckt1qyqrdsefa43s6m882pcj53m4gdnj4k440axqswmu83", (Object)utils.generateFromPublicKey("0x024a501efd328e062c8675f2365970728c859c592beeefd6be8ead3d901330bc01"));
    }

    @Test
    public void testPublicKeyHashToAddressMainnet() {
        AddressUtils utils = new AddressUtils(Network.MAINNET);
        Assertions.assertEquals((Object)"ckb1qyqrdsefa43s6m882pcj53m4gdnj4k440axqdt9rtd", (Object)utils.generateFromPublicKey("0x024a501efd328e062c8675f2365970728c859c592beeefd6be8ead3d901330bc01"));
    }

    @Test
    public void testPrivateKeyHashToAddressTestnet() {
        AddressUtils utils = new AddressUtils(Network.TESTNET);
        String privateKey = "e79f3207ea4980b7fed79956d5934249ceac4751a4fae01a0f7c4a96884bc4e3";
        String publicKey = ECKeyPair.publicKeyFromPrivate((String)privateKey);
        Assertions.assertEquals((Object)"ckt1qyqrdsefa43s6m882pcj53m4gdnj4k440axqswmu83", (Object)utils.generateFromPublicKey(publicKey));
    }

    @Test
    public void testBlake160FromAddressTestnet1() {
        String blake160 = AddressUtils.parse((String)"ckt1qyqrdsefa43s6m882pcj53m4gdnj4k440axqswmu83");
        Assertions.assertEquals((Object)blake160, (Object)"36c329ed630d6ce750712a477543672adab57f4c");
    }

    @Test
    public void testBlake160FromAddressTestnet2() {
        String blake160 = AddressUtils.parse((String)"ckt1qyq2742g7yajdcahqsyn63spqrlspyy8g5pq7xg9tu");
        Assertions.assertEquals((Object)blake160, (Object)"af5548f13b26e3b704093d460100ff0090874502");
    }

    @Test
    public void testBlake160FromAddressMainnet() {
        String blake160 = AddressUtils.parse((String)"ckb1qyqrdsefa43s6m882pcj53m4gdnj4k440axqdt9rtd");
        Assertions.assertEquals((Object)blake160, (Object)"36c329ed630d6ce750712a477543672adab57f4c");
    }

    @Test
    public void testPubkeyHashToAddressMainnetRFC() {
        AddressUtils utils = new AddressUtils(Network.MAINNET);
        Assertions.assertEquals((Object)"ckb1qyqp8eqad7ffy42ezmchkjyz54rhcqf8q9pqrn323p", (Object)utils.generate("0x13e41d6F9292555916f17B4882a5477C01270142"));
    }

    @Test
    public void testGenerateMultiAddress() {
        AddressUtils utils = new AddressUtils(Network.TESTNET, CodeHashType.MULTISIG);
        Assertions.assertEquals((Object)"ckt1qyqlqn8vsj7r0a5rvya76tey9jd2rdnca8lqh4kcuq", (Object)utils.generate("f04cec84bc37f683613bed2f242c9aa1b678e9fe"));
    }

    @Test
    public void testParseMultiAddress() {
        Assertions.assertEquals((Object)"f04cec84bc37f683613bed2f242c9aa1b678e9fe", (Object)AddressUtils.parse((String)"ckt1qyqlqn8vsj7r0a5rvya76tey9jd2rdnca8lqh4kcuq"));
    }
}

