/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.address;

import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.nervos.ckb.address.CodeHashType;
import org.nervos.ckb.address.Network;
import org.nervos.ckb.crypto.Hash;
import org.nervos.ckb.exceptions.AddressFormatException;
import org.nervos.ckb.utils.Bech32;
import org.nervos.ckb.utils.Numeric;

@Deprecated
public class AddressUtils {
    private static final String TYPE = "01";
    private static final String CODE_HASH_IDX_BLAKE160 = "00";
    private static final String CODE_HASH_IDX_MULTISIG = "01";
    private static final String CODE_HASH_IDX_ACP = "02";
    private Network network;
    private CodeHashType codeHashType;

    public AddressUtils(Network network, CodeHashType codeHashType) {
        this.network = network;
        this.codeHashType = codeHashType;
    }

    public AddressUtils(Network network) {
        this.network = network;
        this.codeHashType = CodeHashType.BLAKE160;
    }

    private String getCodeHashIdx() throws AddressFormatException {
        switch (this.codeHashType) {
            case BLAKE160: {
                return CODE_HASH_IDX_BLAKE160;
            }
            case MULTISIG: {
                return "01";
            }
            case ANYONE_CAN_APY: {
                return CODE_HASH_IDX_ACP;
            }
        }
        throw new AddressFormatException("Code hash index error");
    }

    public String generateFromPublicKey(String publicKey) throws AddressFormatException {
        if (!AddressUtils.validatePublicKeyHex(publicKey, true)) {
            throw new IllegalArgumentException("Not a valid compressed public key in hex");
        }
        return this.generate(Hash.blake160(publicKey));
    }

    public static boolean validatePublicKeyHex(String publicKey, boolean compressed) {
        if (!(publicKey = Numeric.cleanHexPrefix(publicKey)).matches("^[0-9a-fA-F]+")) {
            return false;
        }
        int len = publicKey.length();
        if (!compressed) {
            return len == 128;
        }
        char firstHex = publicKey.charAt(0);
        char secondHex = publicKey.charAt(1);
        if (len == 66) {
            return firstHex == '0' && (secondHex == '2' || secondHex == '3');
        }
        if (len == 65) {
            return firstHex == '2' || firstHex == '3';
        }
        return false;
    }

    public String generate(String args) throws AddressFormatException {
        String payload = "01" + this.getCodeHashIdx() + Numeric.cleanHexPrefix(args);
        byte[] data = Numeric.hexStringToByteArray(payload);
        return Bech32.encode(this.prefix(), AddressUtils.convertBits(Bytes.asList((byte[])data), 8, 5, true));
    }

    private static String parsePrefix(String address) {
        Bech32.Bech32Data parsed = Bech32.decode(address);
        byte[] data = AddressUtils.convertBits(Bytes.asList((byte[])parsed.data), 5, 8, false);
        if (data.length == 0) {
            return null;
        }
        Bech32.Bech32Data bech32Data = new Bech32.Bech32Data(parsed.hrp, data);
        return Numeric.toHexStringNoPrefix(bech32Data.data);
    }

    public static CodeHashType parseAddressType(String address) throws AddressFormatException {
        String payload = AddressUtils.parsePrefix(address);
        String prefixCodeHash = payload.substring("01".length());
        if (prefixCodeHash.startsWith(CODE_HASH_IDX_BLAKE160)) {
            return CodeHashType.BLAKE160;
        }
        return CodeHashType.MULTISIG;
    }

    public static String parse(String address) throws AddressFormatException {
        String payload = AddressUtils.parsePrefix(address);
        String prefixCodeHash = payload.substring("01".length());
        if (prefixCodeHash.startsWith(CODE_HASH_IDX_BLAKE160)) {
            return payload.substring("0100".length());
        }
        return payload.substring("0101".length());
    }

    private String prefix() {
        return this.network == Network.MAINNET ? "ckb" : "ckt";
    }

    public String strToAscii(String value) {
        StringBuilder sb = new StringBuilder();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            sb.append(Integer.toHexString(chars[i]));
        }
        return sb.toString();
    }

    public static byte[] convertBits(List<Byte> data, int fromBits, int toBits, boolean pad) throws AddressFormatException {
        int acc = 0;
        int bits = 0;
        int maxv = (1 << toBits) - 1;
        ArrayList<Byte> ret = new ArrayList<Byte>();
        for (Byte value : data) {
            short b = (short)(value & 0xFF);
            if (b >> fromBits > 0) {
                throw new AddressFormatException();
            }
            acc = acc << fromBits | b;
            bits += fromBits;
            while (bits >= toBits) {
                ret.add((byte)(acc >> (bits -= toBits) & maxv));
            }
        }
        if (pad && bits > 0) {
            ret.add((byte)(acc << toBits - bits & maxv));
        } else if (bits >= fromBits || (byte)(acc << toBits - bits & maxv) != 0) {
            throw new AddressFormatException("Strict mode was used but input couldn't be converted without padding");
        }
        return Bytes.toArray(ret);
    }
}

