/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.crypto.secp256k1;

import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.nervos.ckb.crypto.secp256k1.Sign;
import org.nervos.ckb.utils.Numeric;

public class ECKeyPair {
    private final BigInteger privateKey;
    private final BigInteger publicKey;

    public ECKeyPair(BigInteger privateKey, BigInteger publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    public BigInteger getPublicKey() {
        return this.publicKey;
    }

    public static ECKeyPair createWithKeyPair(KeyPair keyPair) {
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        BigInteger privateKeyValue = privateKey.getD();
        byte[] publicKeyBytes = publicKey.getQ().getEncoded(false);
        BigInteger publicKeyValue = new BigInteger(1, Arrays.copyOfRange(publicKeyBytes, 1, publicKeyBytes.length));
        return new ECKeyPair(privateKeyValue, publicKeyValue);
    }

    public static ECKeyPair createWithPrivateKey(BigInteger privateKey, boolean compressed) {
        return new ECKeyPair(privateKey, ECKeyPair.publicKeyFromPrivate(privateKey, compressed));
    }

    public static ECKeyPair createWithPrivateKey(String privateKeyHex, boolean compressed) {
        return new ECKeyPair(Numeric.toBigInt(privateKeyHex), ECKeyPair.publicKeyFromPrivate(Numeric.toBigInt(privateKeyHex), compressed));
    }

    public static ECKeyPair createWithPrivateKey(BigInteger privateKey) {
        return new ECKeyPair(privateKey, ECKeyPair.publicKeyFromPrivate(privateKey));
    }

    public static ECKeyPair createWithPrivateKey(byte[] privateKey) {
        return ECKeyPair.createWithPrivateKey(Numeric.toBigInt(privateKey));
    }

    public static BigInteger publicKeyFromPrivate(BigInteger privateKey) {
        return ECKeyPair.publicKeyFromPrivate(privateKey, true);
    }

    public static String publicKeyFromPrivate(String privateKeyHex) {
        return '0' + ECKeyPair.publicKeyFromPrivate(Numeric.toBigInt(privateKeyHex), true).toString(16);
    }

    public static BigInteger publicKeyFromPrivate(BigInteger privateKey, boolean compressed) {
        ECPoint point = ECKeyPair.publicPointFromPrivate(privateKey);
        byte[] encoded = point.getEncoded(compressed);
        return new BigInteger(1, Arrays.copyOfRange(encoded, compressed ? 0 : 1, encoded.length));
    }

    private static ECPoint publicPointFromPrivate(BigInteger privateKey) {
        if (privateKey.bitLength() > Sign.CURVE.getN().bitLength()) {
            privateKey = privateKey.mod(Sign.CURVE.getN());
        }
        return new FixedPointCombMultiplier().multiply(Sign.CURVE.getG(), privateKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyPair ecKeyPair = (ECKeyPair)o;
        if (!Objects.equals(this.privateKey, ecKeyPair.privateKey)) {
            return false;
        }
        return Objects.equals(this.publicKey, ecKeyPair.publicKey);
    }

    public int hashCode() {
        int result = this.privateKey != null ? this.privateKey.hashCode() : 0;
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        return result;
    }
}

